/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.util.Vector;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import sudoku.network.HostSummary;
import sudoku.ui.UIFrame;
import sudoku.ui.nav.NavButtonTemplate;
import sudoku.ui.nav.NavTemplate;

public class NavCompJoin
extends NavTemplate
implements Runnable {
    private UIFrame uiFrame;
    private NavButtonTemplate connect;
    private NavButtonTemplate back;
    private Thread refreshTimer;
    private JLabel refreshTimeLabel;
    private Boolean refreshTimerOn;
    private int time = 0;
    private Vector vhs = new Vector();
    private JPanel joinPanel = new JPanel();
    private JFormattedTextField ipAdd = new JFormattedTextField();
    private JList serverList = new JList();
    private JScrollPane listPane = new JScrollPane();

    public NavCompJoin(UIFrame uiFrame, String title) {
        super(title);
        this.uiFrame = uiFrame;
        this.connect = new NavButtonTemplate("Connect");
        this.back = new NavButtonTemplate("Back");
        this.refreshTimeLabel = new JLabel("Refreshing List!");
        GridBagConstraints gBC = new GridBagConstraints();
        gBC.insets = new Insets(0, 10, 5, 10);
        gBC.gridx = 0;
        gBC.gridy = 0;
        gBC.gridwidth = 1;
        gBC.anchor = 11;
        gBC.fill = 2;
        gBC.weightx = 1.0;
        gBC.weighty = 0.0;
        GridBagConstraints gBC1 = new GridBagConstraints();
        gBC1.insets = new Insets(0, 5, 0, 5);
        gBC1.gridx = 0;
        gBC1.gridy = 1;
        gBC1.gridwidth = 1;
        gBC1.anchor = 13;
        gBC1.fill = 2;
        gBC1.weightx = 0.0;
        gBC1.weighty = 0.0;
        GridBagConstraints gBC2 = new GridBagConstraints();
        gBC2.insets = new Insets(0, 10, 5, 10);
        gBC2.gridx = 0;
        gBC2.gridy = 2;
        gBC2.gridwidth = 1;
        gBC2.anchor = 10;
        gBC2.fill = 10;
        gBC2.weightx = 0.0;
        gBC2.weighty = 0.0;
        GridBagConstraints gBC3 = new GridBagConstraints();
        gBC3.insets = new Insets(0, 10, 5, 10);
        gBC3.gridx = 0;
        gBC3.gridy = 3;
        gBC3.gridwidth = 1;
        gBC3.anchor = 13;
        gBC3.fill = 2;
        gBC3.weightx = 0.0;
        gBC3.weighty = 0.0;
        GridBagConstraints gBC4 = new GridBagConstraints();
        gBC4.insets = new Insets(0, 10, 5, 10);
        gBC4.gridx = 0;
        gBC4.gridy = 4;
        gBC4.gridwidth = 1;
        gBC4.anchor = 13;
        gBC4.fill = 2;
        gBC4.weightx = 0.0;
        gBC4.weighty = 0.0;
        GridBagConstraints gBC5 = new GridBagConstraints();
        gBC5.insets = new Insets(10, 20, 5, 20);
        gBC5.gridx = 0;
        gBC5.gridy = 5;
        gBC5.gridwidth = 1;
        gBC5.anchor = 11;
        gBC5.fill = 2;
        gBC5.weightx = 0.0;
        gBC5.weighty = 0.0;
        GridBagConstraints gBC6 = new GridBagConstraints();
        gBC6.insets = new Insets(0, 20, 0, 20);
        gBC6.gridx = 0;
        gBC6.gridy = 6;
        gBC6.gridwidth = 1;
        gBC6.anchor = 11;
        gBC6.fill = 2;
        gBC6.weightx = 0.0;
        gBC6.weighty = 1.0;
        this.serverList.setFont(new Font("Monospaced", 0, 11));
        this.serverList.setSelectionMode(0);
        this.serverList.setListData(this.vhs);
        this.listPane.getViewport().add(this.serverList);
        this.listPane.setMinimumSize(new Dimension(160, 140));
        this.refreshTimeLabel.setFont(new Font("SansSerif", 2, 10));
        this.refreshTimeLabel.setAlignmentX(0.5f);
        JTextPane enterIP = this.textLabel("Enter IP Address:");
        enterIP.setAlignmentX(0.5f);
        this.joinPanel.setLayout(new GridBagLayout());
        this.joinPanel.setBackground(Color.white);
        this.joinPanel.add((Component)this.textLabel("Select a game from the list below or enter an IP address and press Connect."), gBC);
        this.joinPanel.add((Component)this.listPane, gBC1);
        this.joinPanel.add((Component)this.refreshTimeLabel, gBC2);
        this.joinPanel.add((Component)enterIP, gBC3);
        this.joinPanel.add((Component)this.ipAdd, gBC4);
        this.joinPanel.add((Component)this.connect, gBC5);
        this.joinPanel.add((Component)this.back, gBC6);
        this.add(this.joinPanel);
        this.ipAdd.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NavCompJoin.this.deselectHost();
            }

            public void mousePressed(MouseEvent evt) {
            }

            public void mouseReleased(MouseEvent evt) {
            }
        });
        this.connect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Connect");
                NavCompJoin.this.connectButton();
            }
        });
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Back");
                NavCompJoin.this.backButton();
            }
        });
        this.refreshTimer = new Thread(this);
        this.refreshTimer.start();
        this.setRefresh(false);
    }

    public void backButton() {
        this.setRefresh(false);
        this.uiFrame.showNavComp();
    }

    public void connectButton() {
        this.setRefresh(false);
        this.connect();
    }

    public void connect() {
        block6: {
            HostSummary host = (HostSummary)this.serverList.getSelectedValue();
            System.out.println("Connecting: " + host);
            if (host == null) {
                System.out.println("No Host Selected");
                try {
                    String ip = this.ipAdd.getText();
                    if (ip.equals("")) {
                        System.out.println("No IP Address Entered");
                        this.setRefresh(true);
                    }
                    if (ip.contains(".")) {
                        System.out.println(String.valueOf(ip) + ": Request Connect");
                        this.setRefresh(false);
                        this.uiFrame.joinGame(ip);
                        break block6;
                    }
                    System.out.println("IP Not Valid");
                    this.setRefresh(true);
                }
                catch (Exception e) {
                    System.out.println("Error Connecting");
                }
            } else {
                InetAddress ipAddress = host.getIP();
                System.out.println(ipAddress + ": Connecting (Host was in List)");
                this.uiFrame.joinGame(ipAddress);
            }
        }
    }

    public void setRefresh(Boolean on) {
        this.connect.setEnabled(on);
        this.refreshTimerOn = on;
        if (on.booleanValue()) {
            this.time = 0;
        }
    }

    public void deselectHost() {
        this.serverList.clearSelection();
        this.serverList.repaint();
    }

    public void run() {
        System.out.println("Refresh Timer Initialised");
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.refreshTimerOn.booleanValue()) {
                if (this.time == 0) {
                    this.vhs.clear();
                    this.uiFrame.refreshJoinList(this.vhs);
                    this.time = 30;
                    this.refreshTimeLabel.setText("Refreshing List!");
                } else if (this.time == 1) {
                    this.refreshTimeLabel.setText("Refreshing in " + this.time + " second");
                    --this.time;
                } else {
                    this.refreshTimeLabel.setText("Refreshing in " + this.time + " seconds");
                    --this.time;
                }
            }
            int selected = this.serverList.getSelectedIndex();
            this.serverList.setListData(this.vhs);
            this.serverList.repaint();
            this.serverList.setSelectedIndex(selected);
            if (!this.ipAdd.isFocusOwner()) continue;
            this.deselectHost();
        }
    }
}

