/*
 * Decompiled with CFR 0.152.
 */
package sudoku.game;

import java.io.Serializable;
import sudoku.game.UserSelectedType;

public class Cell
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3L;
    private byte value = 0;
    private boolean[] scribbles = new boolean[9];
    private boolean given = false;
    private byte xPos = 0;
    private byte yPos = 0;
    private volatile UserSelectedType userSelected = UserSelectedType.NONE;
    private volatile boolean hintSelected = false;

    public Cell(byte xPos, byte yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte v) {
        this.value = v;
    }

    public boolean getScribble(int x) {
        return this.scribbles[x];
    }

    public void setScribble(int x, boolean b) {
        this.scribbles[x] = b;
    }

    public boolean getGiven() {
        return this.given;
    }

    public void setGiven(boolean b) {
        this.given = b;
    }

    public UserSelectedType getUserSelected() {
        return this.userSelected;
    }

    public void setUserSelected(UserSelectedType ust) {
        this.userSelected = ust;
    }

    public boolean getHintSelected() {
        return this.hintSelected;
    }

    public void setHintSelected(boolean b) {
        this.hintSelected = b;
    }

    public byte getXPos() {
        return this.xPos;
    }

    public byte getYPos() {
        return this.yPos;
    }

    public Cell clone() {
        try {
            Cell c = (Cell)super.clone();
            c.scribbles = (boolean[])this.scribbles.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

