/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import sudoku.game.Cell;
import sudoku.game.Puzzle;
import sudoku.game.UserSelectedType;

public class DrawPuzzle {
    private static Color givenDigitColour = new Color(12, 60, 108);
    private static Color givenBackgroundColour = new Color(216, 228, 241);
    private static Color gridColour = Color.BLACK;
    private static Color userDigitColour = Color.BLACK;
    private static Image digitCell;
    private static Image scaledDigitCell;
    private static Image hintCell;
    private static Image scaledHintCell;
    private static Image digitHintCell;
    private static Image scaledDigitHintCell;
    private static Image scribbleHintCell;
    private static Image scaledScribbleHintCell;
    private static Image scribbleCell;
    private static Image scaledScribbleCell;
    private static Image givenCell;
    private static Image scaledGivenCell;
    private static Rectangle puzzlePos;

    static {
        puzzlePos = new Rectangle();
        URL userURL = DrawPuzzle.class.getResource("SelSquare.jpg");
        URL hintURL = DrawPuzzle.class.getResource("HintSquare.jpg");
        URL userHintURL = DrawPuzzle.class.getResource("SelHintSquare.jpg");
        URL scribbleHintURL = DrawPuzzle.class.getResource("ScribbleHintSquare.jpg");
        URL scribbleURL = DrawPuzzle.class.getResource("ScribbleSquare.jpg");
        URL givenURL = DrawPuzzle.class.getResource("GivenSelSquare.jpg");
        try {
            digitCell = ImageIO.read(userURL);
            hintCell = ImageIO.read(hintURL);
            digitHintCell = ImageIO.read(userHintURL);
            scribbleHintCell = ImageIO.read(scribbleHintURL);
            scribbleCell = ImageIO.read(scribbleURL);
            givenCell = ImageIO.read(givenURL);
        }
        catch (IOException e) {
            System.out.println("Could not load puzzle background images.");
        }
    }

    private DrawPuzzle() {
    }

    public static Rectangle draw(Puzzle p, Graphics2D g, int requestedSize, int availWidth, int availHeight) {
        int cellSize = requestedSize / 9;
        int givenFontSize = (int)Math.round(0.9 * (double)cellSize);
        int userFontSize = (int)Math.round(0.8 * (double)cellSize);
        int scribbleFontSize = (int)Math.round(0.25 * (double)cellSize);
        int actualSize = cellSize * 9;
        int xOffset = (availWidth - actualSize) / 2;
        int yOffset = (availHeight - actualSize) / 2;
        int thinLineWidth = cellSize / 60 + 1;
        int thickLineWidth = 2 * thinLineWidth + 1;
        int visibleCellSize = cellSize - thinLineWidth;
        Font given = new Font("SansSerif", 1, givenFontSize);
        Font scribble = new Font("SansSerif", 0, scribbleFontSize);
        Font user = new Font("SansSerif", 0, userFontSize);
        if (DrawPuzzle.puzzlePos.width != actualSize) {
            scaledDigitCell = digitCell.getScaledInstance(visibleCellSize, visibleCellSize, 4);
            scaledHintCell = hintCell.getScaledInstance(visibleCellSize, visibleCellSize, 4);
            scaledDigitHintCell = digitHintCell.getScaledInstance(visibleCellSize, visibleCellSize, 4);
            scaledScribbleCell = scribbleCell.getScaledInstance(visibleCellSize, visibleCellSize, 4);
            scaledScribbleHintCell = scribbleHintCell.getScaledInstance(visibleCellSize, visibleCellSize, 4);
            scaledGivenCell = givenCell.getScaledInstance(visibleCellSize, visibleCellSize, 4);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                int height;
                int width;
                FontMetrics fm;
                Cell c = p.getCell(i, j);
                int cellX = xOffset + cellSize * i;
                int cellY = yOffset + cellSize * j;
                byte val = c.getValue();
                boolean hintSel = c.getHintSelected();
                UserSelectedType userSel = c.getUserSelected();
                boolean digitSel = userSel == UserSelectedType.DIGIT;
                boolean isGiven = c.getGiven();
                boolean givenSel = isGiven && digitSel;
                boolean scribbleSel = userSel == UserSelectedType.SCRIBBLE;
                boolean digitHintSel = hintSel && digitSel;
                boolean scribbleHintSel = hintSel && scribbleSel;
                int bgOffset = (int)Math.ceil((double)thinLineWidth / 2.0);
                int cellXOffset = cellX + bgOffset;
                int cellYOffset = cellY + bgOffset;
                if (digitHintSel) {
                    g.drawImage(scaledDigitHintCell, cellXOffset, cellYOffset, null);
                } else if (givenSel) {
                    g.drawImage(scaledGivenCell, cellXOffset, cellYOffset, null);
                } else if (scribbleHintSel) {
                    g.drawImage(scaledScribbleHintCell, cellXOffset, cellYOffset, null);
                } else if (scribbleSel) {
                    g.drawImage(scaledScribbleCell, cellXOffset, cellYOffset, null);
                } else if (hintSel) {
                    g.drawImage(scaledHintCell, cellXOffset, cellYOffset, null);
                } else if (digitSel) {
                    g.drawImage(scaledDigitCell, cellXOffset, cellYOffset, null);
                } else if (isGiven) {
                    g.setColor(givenBackgroundColour);
                    g.fillRect(cellXOffset, cellYOffset, visibleCellSize, visibleCellSize);
                }
                if (val == 0) {
                    g.setFont(scribble);
                    g.setColor(Color.DARK_GRAY);
                    fm = g.getFontMetrics();
                    width = fm.charWidth('5');
                    height = (int)Math.round((double)fm.getAscent() * 0.7);
                    int s = 0;
                    while (s < 9) {
                        if (c.getScribble(s)) {
                            int miniCellSize = (int)Math.round((double)cellSize * 0.8);
                            int miniOffset = (cellSize - miniCellSize) / 2;
                            int xPos = miniCellSize / 3 * (s % 3) + width / 2 + miniOffset;
                            int yPos = cellSize / 2 + miniCellSize / 3 * (s / 3) - height / 2 - miniOffset;
                            g.drawString(String.valueOf(s + 1), cellX + xPos, cellY + yPos);
                        }
                        ++s;
                    }
                } else {
                    if (c.getGiven()) {
                        g.setFont(given);
                        g.setColor(givenDigitColour);
                    } else {
                        g.setFont(user);
                        g.setColor(userDigitColour);
                    }
                    fm = g.getFontMetrics();
                    width = fm.charWidth(val + 48);
                    height = (int)Math.round((double)fm.getAscent() * 0.7);
                    int xPos = (cellSize - width) / 2;
                    int yPos = (cellSize - height) / 2;
                    g.drawString(String.valueOf(val), cellX + xPos, yOffset + cellSize * (j + 1) - yPos);
                }
                ++j;
            }
            ++i;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(gridColour);
        BasicStroke thin = new BasicStroke(thinLineWidth);
        BasicStroke thick = new BasicStroke(Math.round(thickLineWidth));
        g.setStroke(thick);
        g.drawRect(xOffset, yOffset, actualSize, actualSize);
        int i2 = 1;
        while (i2 < 3) {
            g.drawLine(xOffset + 3 * i2 * cellSize, yOffset, xOffset + 3 * i2 * cellSize, yOffset + actualSize);
            g.drawLine(xOffset, yOffset + 3 * i2 * cellSize, xOffset + actualSize, yOffset + 3 * i2 * cellSize);
            ++i2;
        }
        g.setStroke(thin);
        i2 = 0;
        while (i2 < 3) {
            g.drawLine(xOffset + 3 * i2 * cellSize + cellSize, yOffset, xOffset + 3 * i2 * cellSize + cellSize, yOffset + actualSize);
            g.drawLine(xOffset + 3 * i2 * cellSize + 2 * cellSize, yOffset, xOffset + 3 * i2 * cellSize + 2 * cellSize, yOffset + actualSize);
            g.drawLine(xOffset, yOffset + 3 * i2 * cellSize + cellSize, xOffset + actualSize, yOffset + 3 * i2 * cellSize + cellSize);
            g.drawLine(xOffset, yOffset + 3 * i2 * cellSize + 2 * cellSize, xOffset + actualSize, yOffset + 3 * i2 * cellSize + 2 * cellSize);
            ++i2;
        }
        if (cellSize != DrawPuzzle.puzzlePos.width || xOffset != DrawPuzzle.puzzlePos.x || yOffset != DrawPuzzle.puzzlePos.y) {
            return new Rectangle(xOffset, yOffset, actualSize, actualSize);
        }
        return puzzlePos;
    }
}

