/*
 * Decompiled with CFR 0.152.
 */
package sudoku.network;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import sudoku.game.Puzzle;
import sudoku.game.PuzzleDifficulty;
import sudoku.network.HostSummary;
import sudoku.network.NetworkInterface;
import sudoku.ui.UIFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
implements NetworkInterface {
    private UIFrame uiFrame;
    private DatagramSocket d;
    private Socket t;
    private byte[] localstatus = new byte[2];
    private byte[] goodbye = new byte[1];
    private Timer time;
    private udpConnection udp;
    private tcpConnection tcp;
    private boolean c = true;
    private boolean x = true;
    private boolean z = false;
    private boolean inputpuzzleready = false;
    private Puzzle p;

    public Client(UIFrame uiFrame) {
        this.uiFrame = uiFrame;
    }

    public void getServerList(Vector<HostSummary> serverList) {
        try {
            this.c = true;
            this.d = new DatagramSocket();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        try {
            this.udp = new udpConnection(serverList);
            new Thread(this.udp).start();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        this.time = new Timer();
        this.time.schedule((TimerTask)new ontimer(), 5000L);
    }

    public Puzzle connectTo(InetAddress ip) {
        this.c = true;
        try {
            this.tcp = new tcpConnection(ip);
            new Thread(this.tcp).start();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        while (!this.inputpuzzleready) {
        }
        Puzzle inputpuzzle = this.p;
        this.inputpuzzleready = false;
        return inputpuzzle;
    }

    public void disconnect() {
        try {
            this.c = false;
            if (this.t.isConnected()) {
                this.goodbye[0] = -2;
                this.tcp.out.write(this.goodbye);
            }
            this.tcp.in.close();
            this.d.close();
            this.t.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reportLocalStatus(int cellsComplete, boolean errors) {
        this.localstatus[0] = (byte)cellsComplete;
        this.localstatus[1] = errors ? 1 : 2;
        this.z = true;
        try {
            this.tcp.out.write(this.localstatus);
        }
        catch (IOException e) {
            return;
        }
    }

    class tcpConnection
    extends Thread {
        InputStream in;
        OutputStream out;
        boolean off = false;
        byte[] buffer = new byte[2];
        byte[] puzzleready = new byte[1];
        InetAddress ip;
        Puzzle q;

        public void killThread() {
            try {
                Client.this.t.close();
                Client.this.d.close();
            }
            catch (SocketException e) {
                return;
            }
            catch (IOException e) {
                return;
            }
        }

        public tcpConnection(InetAddress ip) throws SocketException {
            this.ip = ip;
        }

        public void run() {
            try {
                try {
                    Client.this.t = new Socket(this.ip, 10003);
                    Client.this.t.setSoLinger(this.off, 0);
                }
                catch (SocketException e) {
                    Client.this.p = this.q;
                    Client.this.inputpuzzleready = true;
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.in = Client.this.t.getInputStream();
                this.out = Client.this.t.getOutputStream();
                try {
                    ObjectInputStream oin = new ObjectInputStream(this.in);
                    Client.this.p = (Puzzle)oin.readObject();
                    this.puzzleready[0] = -1;
                    this.out.write(this.puzzleready);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                Client.this.inputpuzzleready = true;
                while (Client.this.c) {
                    this.in.read(this.buffer);
                    if (this.buffer[0] == -2) {
                        this.killThread();
                        if (Client.this.x) {
                            Client.this.uiFrame.connectionLost();
                        } else {
                            Client.this.x = true;
                        }
                        this.buffer[0] = 0;
                        return;
                    }
                    if (this.buffer[1] == 1) {
                        Client.this.uiFrame.setOpponentProgress(this.buffer[0], true);
                        this.buffer[1] = 0;
                        this.buffer[0] = 0;
                        continue;
                    }
                    if (this.buffer[1] == 2) {
                        Client.this.uiFrame.setOpponentProgress(this.buffer[0], false);
                        this.buffer[1] = 0;
                        this.buffer[0] = 0;
                        continue;
                    }
                    if (!Client.this.z) continue;
                    this.out.write(Client.this.localstatus);
                    Client.this.z = false;
                }
                Client.this.t.close();
                return;
            }
            catch (IOException e) {
                System.out.println("I/O error");
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class udpConnection
    extends Thread {
        Vector<HostSummary> serverList;

        public udpConnection(Vector<HostSummary> serverList) throws SocketException {
            this.serverList = serverList;
        }

        @Override
        public void run() {
            byte[] token = new byte[2];
            token[1] = 0;
            try {
                Client.this.d.setSoTimeout(0);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            DatagramPacket packet = new DatagramPacket(new byte[100], 100);
            try {
                InetAddress broadcast = InetAddress.getByName("255.255.255.255");
                DatagramPacket pack = new DatagramPacket(token, token.length, broadcast, 10001);
                Client.this.d.send(pack);
                System.out.println("udpRequire");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            while (Client.this.c) {
                try {
                    Client.this.d.receive(packet);
                    System.out.println("received from host");
                    ByteArrayInputStream bytearray = new ByteArrayInputStream(packet.getData());
                    ObjectInputStream oin = new ObjectInputStream(bytearray);
                    PuzzleDifficulty pdi = (PuzzleDifficulty)oin.readObject();
                    this.serverList.add(new HostSummary(packet.getAddress(), pdi));
                }
                catch (StreamCorruptedException e) {
                    return;
                }
                catch (SocketException i) {
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class ontimer
    extends TimerTask {
        ontimer() {
        }

        public void run() {
            Client.this.d.close();
            Client.this.time.cancel();
            System.out.println("hello");
        }
    }
}

