/*
 * Decompiled with CFR 0.152.
 */
package sudoku.game;

import java.util.Random;
import sudoku.game.Puzzle;
import sudoku.game.PuzzleDifficulty;
import sudoku.game.SudokuCell;

public class Solver {
    public SudokuCell[][] arraysOfCells = new SudokuCell[9][9];
    private SudokuCell CurrentCell;
    private int[][] puzzle = new int[9][9];
    private int[] puzzleBed = new int[81];
    private int numberOfGivens = 0;
    public String temp;
    private int[][] puzzleCopy = new int[9][9];
    private boolean[][] booleanStack = new boolean[81][20];
    private int[][] numberStack = new int[81][20];
    private int pointerToCurrentStack = 0;
    private boolean hasUniqueSolution;
    private boolean solutionExist;
    private int[][] solution = new int[9][9];
    private int[][] otherSolution = new int[9][9];
    private int test = 0;
    private int[][] testmore = new int[9][9];

    public Solver() {
        SudokuCell next = null;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                SudokuCell sudokuCell = new SudokuCell(i, j, next);
                this.arraysOfCells[i][j] = sudokuCell;
                next = sudokuCell;
                ++j;
            }
            ++i;
        }
        this.CurrentCell = next;
    }

    public int[][] getPuzzle() {
        return this.puzzle;
    }

    public int getCellValueAt(int row, int column) {
        return this.arraysOfCells[row][column].getValue();
    }

    public void setCellValueAt(int row, int column, int input) {
        this.arraysOfCells[row][column].setValue(input);
    }

    public void clearCells() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.arraysOfCells[i][j].setValue(0);
                ++j;
            }
            ++i;
        }
    }

    public void clearPuzzle() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.puzzle[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public void clearSolution() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.solution[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public void clearOtherSolution() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.otherSolution[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    private int randomInt(int range) {
        Random random = new Random();
        return random.nextInt(range);
    }

    public void toArraysOfCells(int[][] input) {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.arraysOfCells[i][j].setValue(input[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public SudokuCell getCurrentCell() {
        return this.CurrentCell;
    }

    public void toArrays(int[][] input) {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                input[i][j] = this.arraysOfCells[i][j].getValue();
                ++j;
            }
            ++i;
        }
    }

    public void findfindAllImpossibles() {
        this.findAllImpossibleNumbers();
    }

    private void findAllImpossibleNumbers() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                SudokuCell currentCell = this.arraysOfCells[i][j];
                boolean[] currentInvalidNumbersSet = currentCell.getInvalidNumbersSet();
                currentCell.clearAllImpossibleNumbers();
                int k = 0;
                while (k < 20) {
                    int[] currentInvalidRows = currentCell.getInvalidRows();
                    int[] currentInvalidColumns = currentCell.getInvalidColumns();
                    currentInvalidNumbersSet[this.arraysOfCells[currentInvalidRows[k]][currentInvalidColumns[k]].getValue()] = true;
                    ++k;
                }
                k = 1;
                while (k <= 9) {
                    if (currentInvalidNumbersSet[k]) {
                        currentCell.increamentInvalidNumbersCount();
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void minimisePuzzle() {
        int[][] tempPuzzleHolder = this.puzzle;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                System.out.println("position " + i + j + "Cell value = " + this.puzzle[i][j]);
                int copyDigit = this.puzzle[i][j];
                if (this.puzzle[i][j] != 0) {
                    if (this.findUnessesary(i, j, tempPuzzleHolder)) {
                        System.out.println("found unessesary in for loop");
                        this.puzzle[i][j] = 0;
                        System.out.println("location is set to zero" + i + " , " + j);
                    } else {
                        this.puzzle[i][j] = copyDigit;
                    }
                    System.out.println("location remains " + this.puzzle[i][j]);
                } else {
                    System.out.println("zero remains zero");
                }
                ++j;
            }
            ++i;
        }
        this.puzzle = tempPuzzleHolder;
    }

    private void minimiseSymmetricPuzzle() {
        int[][] tempPuzzleHolder = this.puzzle;
        int scanner = 0;
        while (scanner < 41) {
            int row = this.findRow(scanner);
            int column = this.findColumn(scanner);
            int rowSymmetric = 8 - row;
            int columnSymmetric = 8 - column;
            int copyDigit1 = this.puzzle[row][column];
            int copyDigit2 = this.puzzle[rowSymmetric][columnSymmetric];
            if (this.puzzle[row][column] != 0) {
                if (this.findUnessesary(row, column, tempPuzzleHolder) && this.findUnessesary(rowSymmetric, columnSymmetric, tempPuzzleHolder)) {
                    this.puzzle[row][column] = 0;
                    this.puzzle[rowSymmetric][columnSymmetric] = 0;
                } else {
                    this.puzzle[row][column] = copyDigit1;
                    this.puzzle[rowSymmetric][columnSymmetric] = copyDigit2;
                }
            }
            ++scanner;
        }
        System.out.println("Minimised");
        this.puzzle = tempPuzzleHolder;
    }

    private boolean findUnessesary(int i, int j, int[][] input) {
        boolean isUnessesary = false;
        this.puzzleCopy = this.puzzle;
        int[][] tempPuzzleHolder1 = input;
        tempPuzzleHolder1[i][j] = 0;
        SudokuCell[][] tempCells = this.arraysOfCells;
        this.toArraysOfCells(tempPuzzleHolder1);
        this.solve();
        isUnessesary = this.solutionExist & this.hasUniqueSolution;
        this.arraysOfCells = tempCells;
        this.puzzle = this.puzzleCopy;
        return isUnessesary;
    }

    public void push(SudokuCell input) {
        this.pushIntoStack(input);
    }

    public void pop(SudokuCell input) {
        this.popFromStack(input);
    }

    public int getStackPointer() {
        return this.pointerToCurrentStack;
    }

    public void setStackPointer(int input) {
        this.pointerToCurrentStack = input;
    }

    public void increaseStackPointer() {
        ++this.pointerToCurrentStack;
    }

    public void decreaseStackPointer() {
        --this.pointerToCurrentStack;
    }

    private void pushIntoStack(SudokuCell input) {
        int k = 0;
        while (k < 20) {
            int[] currentInvalidRows = input.getInvalidRows();
            int[] currentInvalidColumns = input.getInvalidColumns();
            SudokuCell currentCell = this.arraysOfCells[currentInvalidRows[k]][currentInvalidColumns[k]];
            boolean[] currentInvalidNumbersSet = currentCell.getInvalidNumbersSet();
            this.booleanStack[this.pointerToCurrentStack][k] = currentInvalidNumbersSet[input.getValue()];
            this.numberStack[this.pointerToCurrentStack][k] = currentCell.getInvalidNumbersCount();
            currentInvalidNumbersSet[input.getValue()] = true;
            if (!this.booleanStack[this.pointerToCurrentStack][k]) {
                currentCell.increamentInvalidNumbersCount();
            }
            ++k;
        }
        ++this.pointerToCurrentStack;
    }

    private void popFromStack(SudokuCell input) {
        --this.pointerToCurrentStack;
        int k = 0;
        while (k < 20) {
            int[] currentInvalidRows = input.getInvalidRows();
            int[] currentInvalidColumns = input.getInvalidColumns();
            SudokuCell currentCell = this.arraysOfCells[currentInvalidRows[k]][currentInvalidColumns[k]];
            boolean[] currentInvalidNumbersSet = currentCell.getInvalidNumbersSet();
            currentInvalidNumbersSet[input.getValue()] = this.booleanStack[this.pointerToCurrentStack][k];
            currentCell.setInvalidNumbersCount(this.numberStack[this.pointerToCurrentStack][k]);
            ++k;
        }
    }

    public void print() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                System.out.print(this.arraysOfCells[i][j].getValue());
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void resetPuzzle() {
        this.puzzle = new int[9][9];
    }

    public Puzzle convertToPuzzle() {
        int[][] puzzleArrays = this.getPuzzle();
        Puzzle converted = new Puzzle(PuzzleDifficulty.NOT_RATED);
        byte currentDigit = 0;
        this.numberOfGivens = 0;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                currentDigit = (byte)puzzleArrays[i][j];
                if (currentDigit != 0) {
                    converted.setGiven(i, j, currentDigit);
                    ++this.numberOfGivens;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Number of givens : " + this.numberOfGivens);
        return converted;
    }

    public int getNumberOfGivens() {
        return this.numberOfGivens;
    }

    public Puzzle convertSolutionToPuzzle() {
        Puzzle converted = new Puzzle(PuzzleDifficulty.NOT_RATED);
        byte currentDigit = 0;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                currentDigit = (byte)this.solution[i][j];
                if (this.puzzle[i][j] == 0) {
                    converted.setDigit(i, j, currentDigit);
                } else {
                    converted.setGiven(i, j, currentDigit);
                }
                ++j;
            }
            ++i;
        }
        return converted;
    }

    String toStrings(int[][] array) {
        String result = "";
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                result = array[i][j] == 0 ? result.concat(".") : result.concat(Integer.valueOf(array[i][j]).toString());
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void fillPuzzleBed() {
        int i = 0;
        while (i < 81) {
            this.puzzleBed[i] = i;
            ++i;
        }
    }

    private void randomFillPuzzleBed() {
        int i = 0;
        while (i < 81) {
            int h = this.randomInt(i + 1);
            int hh = this.puzzleBed[h];
            this.puzzleBed[h] = this.puzzleBed[i];
            this.puzzleBed[i] = hh;
            ++i;
        }
    }

    private int findRow(int input) {
        if (input >= 81 && input < 0) {
            return 0;
        }
        int result = this.puzzleBed[input] / 9;
        return result;
    }

    private int findColumn(int input) {
        if (input >= 81 && input < 0) {
            return 0;
        }
        int result = this.puzzleBed[input] - this.puzzleBed[input] / 9 * 9;
        return result;
    }

    public void convertFromPuzzle(Puzzle p) {
        int[][] tempHolder = new int[9][9];
        byte currentDigit = 0;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                if (p.getCell(i, j).getGiven()) {
                    currentDigit = p.getCell(i, j).getValue();
                    tempHolder[i][j] = currentDigit;
                }
                ++j;
            }
            ++i;
        }
        this.puzzle = tempHolder;
        this.toArraysOfCells(tempHolder);
    }

    public void produce() {
        this.clearCells();
        this.clearPuzzle();
        this.fillPuzzleBed();
        this.randomFillPuzzleBed();
        int row = this.findRow(0);
        int column = this.findColumn(0);
        this.puzzle[row][column] = 1;
        block0: while (true) {
            this.toArraysOfCells(this.puzzle);
            this.solve();
            if (this.checkIfUnique()) break;
            int i = 0;
            while (true) {
                if (i >= 81) continue block0;
                row = this.findRow(i);
                if (this.getSolutionAt(row, column = this.findColumn(i)) != this.getOtherSolutionAt(row, column)) {
                    this.puzzle[row][column] = this.getSolutionAt(row, column);
                    continue block0;
                }
                ++i;
            }
            break;
        }
        this.toArraysOfCells(this.puzzle);
    }

    public void produceSymmetric() {
        this.clearCells();
        this.clearPuzzle();
        int i = this.randomInt(9);
        int j = this.randomInt(9);
        this.puzzle[i][j] = 1;
        this.puzzle[8 - i][j] = 2;
        this.puzzle[i][8 - j] = 3;
        this.puzzle[8 - i][8 - j] = 4;
        this.fillPuzzleBed();
        this.randomFillPuzzleBed();
        block0: while (true) {
            this.toArraysOfCells(this.puzzle);
            this.solve();
            if (this.checkIfUnique()) break;
            int k = 0;
            while (true) {
                int column;
                if (k >= 81) continue block0;
                int row = this.findRow(k);
                if (this.getSolutionAt(row, column = this.findColumn(k)) != this.getOtherSolutionAt(row, column)) {
                    this.puzzle[row][column] = this.getSolutionAt(row, column);
                    this.puzzle[8 - row][column] = this.getSolutionAt(8 - row, column);
                    this.puzzle[row][8 - column] = this.getSolutionAt(row, 8 - column);
                    this.puzzle[8 - row][8 - column] = this.getSolutionAt(8 - row, 8 - column);
                    continue block0;
                }
                ++k;
            }
            break;
        }
        this.minimiseSymmetricPuzzle();
        this.toArraysOfCells(this.puzzle);
    }

    public void produceRotationalSymmetric1() {
        this.clearCells();
        this.clearPuzzle();
        int i = this.randomInt(9);
        int j = this.randomInt(9);
        this.puzzle[i][j] = 1;
        this.puzzle[8 - i][8 - j] = 2;
        this.fillPuzzleBed();
        this.randomFillPuzzleBed();
        block0: while (true) {
            this.toArraysOfCells(this.puzzle);
            this.solve();
            if (this.checkIfUnique()) break;
            int k = 0;
            while (true) {
                int column;
                if (k >= 81) continue block0;
                int row = this.findRow(k);
                if (this.getSolutionAt(row, column = this.findColumn(k)) != this.getOtherSolutionAt(row, column)) {
                    this.puzzle[row][column] = this.getSolutionAt(row, column);
                    this.puzzle[8 - row][8 - column] = this.getSolutionAt(8 - row, 8 - column);
                    continue block0;
                }
                ++k;
            }
            break;
        }
        this.toArraysOfCells(this.puzzle);
    }

    public void produceRotationalSymmetric() {
        this.clearCells();
        this.clearPuzzle();
        int i = this.randomInt(9);
        int j = this.randomInt(9);
        this.puzzle[i][j] = 1;
        this.puzzle[8 - i][8 - j] = 2;
        if (!this.checkInitial(i, j, this.puzzle[i][j], this.puzzle[8 - i][8 - j])) {
            System.out.println("Crashed , restarting");
            this.produceRotationalSymmetric();
        }
        this.fillPuzzleBed();
        this.randomFillPuzzleBed();
        block0: while (true) {
            this.toArraysOfCells(this.puzzle);
            this.solve();
            if (this.checkIfUnique()) break;
            int k = 0;
            while (true) {
                int column;
                if (k >= 81) continue block0;
                int row = this.findRow(k);
                if (this.getSolutionAt(row, column = this.findColumn(k)) != this.getOtherSolutionAt(row, column)) {
                    this.puzzle[row][column] = this.getSolutionAt(row, column);
                    this.puzzle[8 - row][8 - column] = this.getSolutionAt(8 - row, 8 - column);
                }
                ++k;
            }
            break;
        }
        this.minimiseSymmetricPuzzle();
        this.toArraysOfCells(this.puzzle);
    }

    private boolean checkInitial(int row, int column, int a, int b) {
        boolean checkSuccessful = true;
        if (!(row == column & column == 4)) {
            if (row == 4 && column != 4 && a == b || column == 4 && row != 4 && a == b) {
                System.out.println("1st");
                checkSuccessful = false;
            } else if (row / 3 == 1 && column / 3 == 1 && a == b) {
                System.out.println("2nd");
                checkSuccessful = false;
            }
        }
        return checkSuccessful;
    }

    public void toArraysOfCells(String input) {
        if (input.length() != 81) {
            return;
        }
        int[][] converted = new int[9][9];
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                char c = input.charAt(j * 9 + i);
                converted[i][j] = c >= '1' && c <= '9' ? c - 48 : 0;
                ++j;
            }
            ++i;
        }
        this.toArraysOfCells(converted);
    }

    public int[][] toArrays(String input) {
        if (input.length() != 81) {
            int[][] blank = new int[9][9];
            return blank;
        }
        int[][] converted = new int[9][9];
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                char c = input.charAt(j * 9 + i);
                converted[i][j] = c >= '1' && c <= '9' ? c - 48 : 0;
                ++j;
            }
            ++i;
        }
        return converted;
    }

    public String toString() {
        String s = "";
        int[][] converted = new int[9][9];
        this.toArrays(converted);
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                s = converted[j][i] != 0 ? String.valueOf(s) + (char)(48 + converted[j][i]) : String.valueOf(s) + '.';
                ++j;
            }
            ++i;
        }
        return s;
    }

    public int[][] getSolution() {
        return this.solution;
    }

    public int getSolutionAt(int row, int column) {
        return this.solution[row][column];
    }

    public int[][] getOtherSolution() {
        return this.otherSolution;
    }

    public int getOtherSolutionAt(int row, int column) {
        return this.otherSolution[row][column];
    }

    public boolean checkIfUnique() {
        return this.hasUniqueSolution;
    }

    public boolean checkIfHasSolution() {
        return this.solutionExist;
    }

    private SudokuCell findCellWithMostInvalidNumbers() {
        SudokuCell cellWithMostInvalidNumbers = null;
        int currentHighInvalidCount = -1;
        SudokuCell currentCell = this.getCurrentCell();
        while (currentCell != null) {
            if (currentCell.getValue() == 0 && currentHighInvalidCount < currentCell.getInvalidNumbersCount()) {
                cellWithMostInvalidNumbers = currentCell;
                currentHighInvalidCount = currentCell.getInvalidNumbersCount();
            }
            currentCell = currentCell.getNextCell();
        }
        return cellWithMostInvalidNumbers;
    }

    private int findMaxInvalidCount() {
        int maxInvalidCount = -1;
        SudokuCell currentCell = this.getCurrentCell();
        while (currentCell != null) {
            if (currentCell.getValue() == 0 && maxInvalidCount < currentCell.getInvalidNumbersCount()) {
                maxInvalidCount = currentCell.getInvalidNumbersCount();
            }
            currentCell = currentCell.getNextCell();
        }
        return maxInvalidCount;
    }

    public boolean solve() {
        this.solutionExist = false;
        this.setStackPointer(0);
        this.findfindAllImpossibles();
        SudokuCell currentCell = this.getCurrentCell();
        while (currentCell != null) {
            boolean[] currentInvalidNumbersSet = currentCell.getInvalidNumbersSet();
            if (!currentCell.ifEqual(0) && currentInvalidNumbersSet[currentCell.getValue()]) {
                return false;
            }
            currentCell = currentCell.getNextCell();
        }
        this.interate();
        if (this.solutionExist) {
            this.toArraysOfCells(this.solution);
        }
        return this.solutionExist;
    }

    private boolean interate() {
        SudokuCell cellWithMostInvalidNumbers = this.findCellWithMostInvalidNumbers();
        int maxInvalidCount = this.findMaxInvalidCount();
        if (maxInvalidCount == 9) {
            return false;
        }
        if (cellWithMostInvalidNumbers == null) {
            if (this.solutionExist) {
                this.hasUniqueSolution = false;
                this.toArrays(this.otherSolution);
                return true;
            }
            this.hasUniqueSolution = true;
            this.solutionExist = true;
            this.toArrays(this.solution);
            return false;
        }
        boolean[] currentInvalidNumbersSet = cellWithMostInvalidNumbers.getInvalidNumbersSet();
        int i = 1;
        while (i <= 9) {
            if (!currentInvalidNumbersSet[i]) {
                cellWithMostInvalidNumbers.setValue(i);
                this.push(cellWithMostInvalidNumbers);
                if (this.interate()) {
                    this.decreaseStackPointer();
                    return true;
                }
                this.pop(cellWithMostInvalidNumbers);
            }
            ++i;
        }
        cellWithMostInvalidNumbers.setValue(0);
        return false;
    }
}

