/*
 * Decompiled with CFR 0.152.
 */
package sudoku.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import sudoku.game.Puzzle;

public class SaveRestore {
    private File file;
    private JFileChooser chooser = new JFileChooser();
    private FileFilterSud ff = new FileFilterSud();

    public SaveRestore() {
        this.chooser.setFileFilter(this.ff);
    }

    public void save(Puzzle p, JFrame f) {
        if (this.file == null) {
            System.out.println("file = null");
            this.saveAs(p, f);
        } else {
            try {
                System.out.println("Save as : " + this.file.getName());
                FileOutputStream out = new FileOutputStream(this.file);
                ObjectOutputStream s = new ObjectOutputStream(out);
                s.writeObject(p);
                s.close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void saveAs(Puzzle p, JFrame f) {
        try {
            int returnVal = this.chooser.showSaveDialog(f);
            if (returnVal == 0) {
                this.file = this.chooser.getSelectedFile();
                String name = this.file.getName();
                if (!name.endsWith("sud")) {
                    this.file = new File(this.file.getCanonicalFile() + ".sud");
                }
                System.out.println("Save as : " + name);
                if (name != null) {
                    FileOutputStream out = new FileOutputStream(this.file);
                    ObjectOutputStream s = new ObjectOutputStream(out);
                    s.writeObject(p);
                    s.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public Puzzle load(JFrame f, Puzzle p) {
        try {
            int returnVal = this.chooser.showOpenDialog(f);
            if (returnVal == 1) {
                p = null;
            }
            if (returnVal == 0) {
                File openedFile = this.chooser.getSelectedFile();
                System.out.println("Open file: " + openedFile.getName());
                if (openedFile.getName() != null) {
                    FileInputStream in = new FileInputStream(openedFile);
                    ObjectInputStream s = new ObjectInputStream(in);
                    p = (Puzzle)s.readObject();
                    s.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return p;
    }

    public void clearFilename() {
        this.file = null;
    }

    public String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private class FileFilterSud
    extends FileFilter {
        FileFilterSud() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = SaveRestore.this.getExtension(f);
            if (extension != null) {
                return extension.equals("sud");
            }
            return false;
        }

        public String getDescription() {
            return ".sud files";
        }
    }
}

