/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import sudoku.data.Print;
import sudoku.data.SaveRestore;
import sudoku.game.Generator;
import sudoku.game.Hint;
import sudoku.game.Puzzle;
import sudoku.game.PuzzleDifficulty;
import sudoku.network.Client;
import sudoku.network.HostSummary;
import sudoku.network.Server;
import sudoku.ui.AboutDialog;
import sudoku.ui.CompEndDialog;
import sudoku.ui.CompEndResult;
import sudoku.ui.FixedPuzzleStack;
import sudoku.ui.HintPanel;
import sudoku.ui.MainPanel;
import sudoku.ui.SingleEndDialog;
import sudoku.ui.SingleEndResult;
import sudoku.ui.nav.NavComp;
import sudoku.ui.nav.NavCompHost;
import sudoku.ui.nav.NavCompJoin;
import sudoku.ui.nav.NavCompPlay;
import sudoku.ui.nav.NavCustom;
import sudoku.ui.nav.NavDifficulty;
import sudoku.ui.nav.NavMain;
import sudoku.ui.nav.NavSingle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFrame
extends JFrame
implements Runnable {
    private NavMain navMain;
    private NavDifficulty navDifficulty;
    private NavSingle navSingle;
    private NavCustom navCustom;
    private NavComp navComp;
    private NavCompHost navCompHost;
    private NavCompJoin navCompJoin;
    private NavCompPlay navCompPlay;
    private String currentPanel;
    private String previousPanel;
    private HintPanel hintPanel;
    private MainPanel mainPanel;
    private AboutDialog about;
    private CompEndDialog compEndDlg;
    private CompEndResult cER;
    private SingleEndDialog singEndDlg;
    private SingleEndResult sER;
    private Boolean compMode;
    private Boolean singMode;
    private Boolean custMode;
    private Boolean generate;
    private Boolean serverMachine;
    private Boolean clientMachine;
    private Boolean paused = false;
    private int hintLevel;
    private Thread t1;
    private PuzzleDifficulty diff = PuzzleDifficulty.NOT_RATED;
    private JMenuItem save_menu_item = new JMenuItem("Save");
    private JMenuItem saveas_menu_item = new JMenuItem("Save As...");
    private JMenuItem load_menu_item = new JMenuItem("Load");
    private JMenuItem print_menu_item = new JMenuItem("Print");
    private JMenuItem exit_menu_item = new JMenuItem("Exit");
    private JMenuItem undo_menu_item = new JMenuItem("Undo");
    private JMenuItem redo_menu_item = new JMenuItem("Redo");
    private JMenuItem generatenew_menu_item = new JMenuItem("New Puzzle");
    private JMenuItem custom_menu_item = new JMenuItem("Enter Custom");
    private JMenuItem reset_menu_item = new JMenuItem("Reset Grid");
    private JMenuItem hint_menu_item = new JMenuItem("Hint!");
    private JMenuItem pause_menu_item = new JMenuItem("Pause");
    private JCheckBoxMenuItem timer_checkbox = new JCheckBoxMenuItem("Timer");
    private JMenuItem solve_menu_item = new JMenuItem("Solve");
    private JMenuItem endgame_menu_item = new JMenuItem("End Game");
    private JMenuItem host_menu_item = new JMenuItem("Host Game");
    private JMenuItem join_menu_item = new JMenuItem("Join Game");
    private JMenuItem instructions_menu_item = new JMenuItem("Instructions");
    private JMenuItem about_menu_item = new JMenuItem("About");
    private JMenu multi_menu = new JMenu("Multiplayer");
    private Client client = new Client(this);
    private Server server = new Server(this);
    private SaveRestore saveRestore = new SaveRestore();
    private Puzzle puzzle = new Puzzle(PuzzleDifficulty.NOT_RATED);
    private JPanel navCards = new JPanel(new CardLayout());
    private CardLayout cl = (CardLayout)this.navCards.getLayout();
    private FixedPuzzleStack undoList = new FixedPuzzleStack(10);
    private FixedPuzzleStack redoList = new FixedPuzzleStack(10);

    public UIFrame() {
        super("Synthetic Sudoku - A Project By Group India");
        Container cp = this.getContentPane();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JFrame f = (JFrame)e.getSource();
                if (f.getWidth() < 800 || f.getHeight() < 600) {
                    f.setSize(800, 600);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        this.mainPanel = new MainPanel(this);
        this.mainPanel.setPreferredSize(new Dimension(600, 550));
        this.hintPanel = new HintPanel(this);
        this.hintPanel.setPreferredSize(new Dimension(10, 50));
        this.about = new AboutDialog(this);
        this.compEndDlg = new CompEndDialog(this);
        this.navMain = new NavMain(this, "Main Menu");
        this.navDifficulty = new NavDifficulty(this, "Select Difficulty");
        this.navSingle = new NavSingle(this, "Single Player");
        this.navCustom = new NavCustom(this, "Custom Puzzle");
        this.navComp = new NavComp(this, "Multiplayer");
        this.navCompHost = new NavCompHost(this, "Host A Game");
        this.navCompJoin = new NavCompJoin(this, "Join A Game");
        this.navCompPlay = new NavCompPlay(this, "Competition Mode");
        this.previousPanel = "Previous";
        this.currentPanel = "navMain";
        this.navCards.add((Component)this.navMain, "navMain");
        this.navCards.add((Component)this.navDifficulty, "navDifficulty");
        this.navCards.add((Component)this.navSingle, "navSingle");
        this.navCards.add((Component)this.navCustom, "navCustom");
        this.navCards.add((Component)this.navComp, "navComp");
        this.navCards.add((Component)this.navCompHost, "navCompHost");
        this.navCards.add((Component)this.navCompJoin, "navCompJoin");
        this.navCards.add((Component)this.navCompPlay, "navCompPlay");
        this.navCards.setBorder(new LineBorder(Color.BLACK));
        this.navCards.setPreferredSize(new Dimension(200, 50));
        this.navCards.setBackground(Color.white);
        BorderLayout b = new BorderLayout();
        JPanel workPanel = new JPanel(b);
        workPanel.setBorder(new LineBorder(Color.BLACK));
        workPanel.add((Component)this.mainPanel, "Center");
        workPanel.add((Component)this.hintPanel, "South");
        cp.add((Component)this.navCards, "West");
        cp.add((Component)workPanel, "Center");
        JMenuBar menu_bar = new JMenuBar();
        JMenu file_menu = new JMenu("File");
        JMenu edit_menu = new JMenu("Edit");
        JMenu puzzle_menu = new JMenu("Puzzle");
        JMenu help_menu = new JMenu("Help");
        this.timer_checkbox.setSelected(true);
        this.save_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Save");
                UIFrame.this.saveGame();
            }
        });
        this.saveas_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Save As");
                UIFrame.this.saveGameAs();
            }
        });
        this.load_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Load");
                UIFrame.this.loadGame();
            }
        });
        this.print_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Print");
                UIFrame.this.printPuzzle();
            }
        });
        this.exit_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Exit");
                UIFrame.this.exitApplication();
            }
        });
        this.undo_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Undo");
                UIFrame.this.undo();
            }
        });
        this.redo_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Redo");
                UIFrame.this.redo();
            }
        });
        this.custom_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Custom Mode");
                UIFrame.this.navDifficulty.customPuzzle();
                UIFrame.this.setSingMode(true);
            }
        });
        this.generatenew_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Generate New");
                UIFrame.this.mainPanel.setPuzzle(null);
                UIFrame.this.setSingMode(true);
                UIFrame.this.setCustMode(false);
                UIFrame.this.singlePlayer();
            }
        });
        this.reset_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Restart");
                UIFrame.this.resetGrid();
            }
        });
        this.hint_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Hint");
                UIFrame.this.hint();
            }
        });
        this.pause_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Pause");
                UIFrame.this.pauseGame();
            }
        });
        this.timer_checkbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Timer");
                UIFrame.this.switchTimer();
            }
        });
        this.solve_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Solve");
                UIFrame.this.solve();
            }
        });
        this.endgame_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - End Game");
                UIFrame.this.endGame();
            }
        });
        this.host_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Host");
                UIFrame.this.setCompMode(true);
                UIFrame.this.hostCompetitionSetup();
            }
        });
        this.join_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Join");
                UIFrame.this.setCompMode(true);
                UIFrame.this.showNavCompJoin();
            }
        });
        this.instructions_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - Instructions");
                UIFrame.this.displayInstructions();
            }
        });
        this.about_menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Menu button pushed - About");
                UIFrame.this.showAboutDialog();
            }
        });
        file_menu.setMnemonic('f');
        edit_menu.setMnemonic('e');
        puzzle_menu.setMnemonic('z');
        help_menu.setMnemonic('h');
        this.multi_menu.setMnemonic('m');
        this.save_menu_item.setMnemonic('s');
        this.saveas_menu_item.setMnemonic('a');
        this.load_menu_item.setMnemonic('l');
        this.print_menu_item.setMnemonic('p');
        this.exit_menu_item.setMnemonic('x');
        this.undo_menu_item.setMnemonic('u');
        this.redo_menu_item.setMnemonic('r');
        this.generatenew_menu_item.setMnemonic('g');
        this.custom_menu_item.setMnemonic('c');
        this.reset_menu_item.setMnemonic('r');
        this.hint_menu_item.setMnemonic('i');
        this.pause_menu_item.setMnemonic('p');
        this.timer_checkbox.setMnemonic('t');
        this.solve_menu_item.setMnemonic('s');
        this.host_menu_item.setMnemonic('h');
        this.join_menu_item.setMnemonic('j');
        this.endgame_menu_item.setMnemonic('n');
        this.instructions_menu_item.setMnemonic('i');
        this.about_menu_item.setMnemonic('a');
        this.save_menu_item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveas_menu_item.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.load_menu_item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.print_menu_item.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.undo_menu_item.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redo_menu_item.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.generatenew_menu_item.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.hint_menu_item.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.pause_menu_item.setAccelerator(KeyStroke.getKeyStroke("P"));
        this.instructions_menu_item.setAccelerator(KeyStroke.getKeyStroke("F1"));
        file_menu.add(this.save_menu_item);
        file_menu.add(this.saveas_menu_item);
        file_menu.add(this.load_menu_item);
        file_menu.add(this.print_menu_item);
        file_menu.addSeparator();
        file_menu.add(this.exit_menu_item);
        edit_menu.add(this.undo_menu_item);
        edit_menu.add(this.redo_menu_item);
        puzzle_menu.add(this.generatenew_menu_item);
        puzzle_menu.add(this.custom_menu_item);
        puzzle_menu.add(this.reset_menu_item);
        puzzle_menu.add(this.hint_menu_item);
        puzzle_menu.add(this.solve_menu_item);
        puzzle_menu.add(this.pause_menu_item);
        puzzle_menu.add(this.timer_checkbox);
        puzzle_menu.addSeparator();
        this.multi_menu.add(this.host_menu_item);
        this.multi_menu.add(this.join_menu_item);
        puzzle_menu.add(this.multi_menu);
        puzzle_menu.addSeparator();
        puzzle_menu.add(this.endgame_menu_item);
        help_menu.add(this.instructions_menu_item);
        help_menu.add(this.about_menu_item);
        menu_bar.add(file_menu);
        menu_bar.add(edit_menu);
        menu_bar.add(puzzle_menu);
        menu_bar.add(help_menu);
        this.setJMenuBar(menu_bar);
        this.compMode = false;
        this.singMode = false;
        this.server = new Server(this);
        this.client = new Client(this);
        this.showNavMain();
        this.generate = false;
        this.t1 = new Thread(this);
        this.pack();
        this.t1.start();
    }

    public void showNavMain() {
        this.swapNavTo("navMain");
        this.save_menu_item.setEnabled(false);
        this.saveas_menu_item.setEnabled(false);
        this.load_menu_item.setEnabled(true);
        this.print_menu_item.setEnabled(false);
        this.exit_menu_item.setEnabled(true);
        this.undo_menu_item.setEnabled(false);
        this.redo_menu_item.setEnabled(false);
        this.generatenew_menu_item.setEnabled(true);
        this.custom_menu_item.setEnabled(true);
        this.reset_menu_item.setEnabled(false);
        this.hint_menu_item.setEnabled(false);
        this.pause_menu_item.setEnabled(false);
        this.timer_checkbox.setEnabled(true);
        this.solve_menu_item.setEnabled(false);
        this.host_menu_item.setEnabled(true);
        this.join_menu_item.setEnabled(true);
        this.endgame_menu_item.setEnabled(false);
        this.instructions_menu_item.setEnabled(true);
        this.about_menu_item.setEnabled(true);
        this.hintPanel.hideButton();
        this.hintPanel.setVisible(false);
        this.compMode = false;
        this.singMode = false;
        this.setCustMode(false);
        this.mainPanel.setPuzzle(null);
        this.navSingle.setTimer(false);
    }

    public void showNavDifficulty() {
        this.swapNavTo("navDifficulty");
        this.setCustMode(false);
        this.navDifficulty.waitingState(false);
    }

    public void showNavSingle() {
        this.swapNavTo("navSingle");
        this.save_menu_item.setEnabled(true);
        this.saveas_menu_item.setEnabled(true);
        this.load_menu_item.setEnabled(true);
        this.print_menu_item.setEnabled(true);
        this.exit_menu_item.setEnabled(true);
        this.undo_menu_item.setEnabled(true);
        this.redo_menu_item.setEnabled(true);
        this.generatenew_menu_item.setEnabled(true);
        this.custom_menu_item.setEnabled(true);
        this.reset_menu_item.setEnabled(true);
        this.hint_menu_item.setEnabled(true);
        this.pause_menu_item.setEnabled(true);
        this.timer_checkbox.setEnabled(true);
        this.solve_menu_item.setEnabled(true);
        this.host_menu_item.setEnabled(true);
        this.join_menu_item.setEnabled(true);
        this.endgame_menu_item.setEnabled(true);
        this.instructions_menu_item.setEnabled(true);
        this.about_menu_item.setEnabled(true);
        this.setSingMode(true);
        this.resetSinglePanel();
    }

    public void showNavCustom() {
        this.swapNavTo("navCustom");
    }

    public void showNavComp() {
        this.swapNavTo("navComp");
        this.mainPanel.setPuzzle(null);
    }

    public void showNavCompHost() {
        this.swapNavTo("navCompHost");
        this.mainPanel.setPuzzle(null);
    }

    public void showNavCompJoin() {
        this.swapNavTo("navCompJoin");
        this.navCompJoin.setRefresh(true);
        this.mainPanel.setPuzzle(null);
    }

    public void showNavCompPlay() {
        this.swapNavTo("navCompPlay");
        this.save_menu_item.setEnabled(true);
        this.saveas_menu_item.setEnabled(true);
        this.load_menu_item.setEnabled(false);
        this.print_menu_item.setEnabled(true);
        this.exit_menu_item.setEnabled(true);
        this.undo_menu_item.setEnabled(true);
        this.redo_menu_item.setEnabled(true);
        this.generatenew_menu_item.setEnabled(false);
        this.custom_menu_item.setEnabled(false);
        this.reset_menu_item.setEnabled(true);
        this.hint_menu_item.setEnabled(true);
        this.pause_menu_item.setEnabled(false);
        this.timer_checkbox.setEnabled(false);
        this.solve_menu_item.setEnabled(false);
        this.host_menu_item.setEnabled(true);
        this.join_menu_item.setEnabled(true);
        this.endgame_menu_item.setEnabled(true);
        this.instructions_menu_item.setEnabled(true);
        this.about_menu_item.setEnabled(true);
        this.setCompMode(true);
        this.resetCompPlayPanel();
    }

    public void showPreviousNav() {
        this.swapNavTo("previousPanel");
    }

    private void swapNavTo(String nextPanel) {
        this.previousPanel = this.currentPanel;
        this.currentPanel = nextPanel;
        System.out.println(String.valueOf(this.previousPanel) + " > " + nextPanel);
        this.cl.show(this.navCards, nextPanel);
    }

    public void setCompMode(Boolean on) {
        this.compMode = on;
        this.singMode = on == false;
    }

    public Boolean getCompMode() {
        return this.compMode;
    }

    public void setSingMode(Boolean on) {
        this.singMode = on;
        this.compMode = on == false;
    }

    public Boolean getSingMode() {
        return this.singMode;
    }

    public void setCustMode(Boolean custom) {
        this.custMode = custom;
    }

    public Boolean getCustMode() {
        return this.custMode;
    }

    public void setOpponentProgress(int complete, boolean errors) {
        System.out.println("Opponent Progress Received: " + complete + " Errors: " + errors);
        this.navCompPlay.setOpponentProgress(complete, errors);
    }

    public void loadGame() {
        System.out.println("loadGame()");
        Puzzle p = new Puzzle(PuzzleDifficulty.NOT_RATED);
        p = this.saveRestore.load(this, p);
        if (p == null) {
            System.out.println("Cancel Load (Null Puzzle)");
        } else {
            this.puzzle = p;
            this.mainPanel.setPuzzle(this.puzzle);
            this.mainPanel.repaint();
            this.showNavSingle();
        }
    }

    public void saveGame() {
        System.out.println("saveGame()");
        this.saveRestore.save(this.puzzle, this);
    }

    public void saveGameAs() {
        System.out.println("saveGameAs()");
        this.saveRestore.saveAs(this.puzzle, this);
    }

    public void printPuzzle() {
        System.out.println("printPuzzle()");
        int option = JOptionPane.showConfirmDialog(this, "Do you want the printed puzzle to fill the page?");
        if (option == 0) {
            Print.print(this.puzzle, 0);
        }
        if (option == 1) {
            Print.print(this.puzzle, 1);
        }
    }

    public void exitApplication() {
        System.out.println("exitApplication()");
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to quit 'Synthetic Sudoku'?", "Exit Game?", 0) == 0) {
            System.exit(0);
        }
    }

    public void pauseGame() {
        System.out.println("pauseGame()");
        this.paused = this.paused == false;
        this.navSingle.pauseMode(this.paused);
        this.load_menu_item.setEnabled(this.paused == false);
        this.print_menu_item.setEnabled(this.paused == false);
        this.undo_menu_item.setEnabled(this.paused == false);
        this.redo_menu_item.setEnabled(this.paused == false);
        this.generatenew_menu_item.setEnabled(this.paused == false);
        this.custom_menu_item.setEnabled(this.paused == false);
        this.reset_menu_item.setEnabled(this.paused == false);
        this.hint_menu_item.setEnabled(this.paused == false);
        this.timer_checkbox.setEnabled(this.paused == false);
        this.solve_menu_item.setEnabled(this.paused == false);
        this.multi_menu.setEnabled(this.paused == false);
        this.host_menu_item.setEnabled(this.paused == false);
        this.join_menu_item.setEnabled(this.paused == false);
        if (this.paused.booleanValue()) {
            this.navSingle.setTimer(false);
            this.mainPanel.setPuzzle(null);
            this.hintPanelVisible(false);
            this.pause_menu_item.setText("Resume");
            this.pause_menu_item.setMnemonic('m');
        } else {
            this.mainPanel.setPuzzle(this.puzzle);
            this.hintPanelVisible(true);
            this.navSingle.setTimer(true);
            this.pause_menu_item.setText("Pause");
            this.pause_menu_item.setMnemonic('p');
        }
    }

    public void setPuzzleTime(long t) {
        this.puzzle.setTime(t);
    }

    public long getPuzzleTime() {
        long t = this.puzzle.getTime();
        return t;
    }

    public void resetGrid() {
        System.out.println("resetGrid()");
        this.saveRestore.clearFilename();
        this.puzzle.resetGrid();
        this.mainPanel.repaint();
        this.undoList.clear();
        this.redoList.clear();
        this.hintPanel.hideButton();
        this.navSingle.undoEnable(false);
        this.navSingle.redoEnable(false);
        this.navCompPlay.undoEnable(false);
        this.navCompPlay.redoEnable(false);
        this.resetHintLevel();
    }

    public void solve() {
        Puzzle p;
        System.out.println("solve()");
        this.puzzle = p = Generator.solve(this.puzzle);
        this.mainPanel.setPuzzle(this.puzzle);
        this.navSingle.solveDisplay();
        this.undo_menu_item.setEnabled(false);
        this.redo_menu_item.setEnabled(false);
        this.reset_menu_item.setEnabled(false);
        this.hint_menu_item.setEnabled(false);
        this.timer_checkbox.setEnabled(false);
        this.solve_menu_item.setEnabled(false);
        this.multi_menu.setEnabled(false);
        this.host_menu_item.setEnabled(false);
        this.join_menu_item.setEnabled(false);
        this.save_menu_item.setEnabled(false);
        this.saveas_menu_item.setEnabled(false);
        this.pause_menu_item.setEnabled(false);
    }

    public void undo() {
        System.out.println("undo()");
        this.redoList.push(this.puzzle.clone());
        this.puzzle = this.undoList.pop();
        Puzzle nextPuzzle = this.undoList.peek();
        this.navSingle.redoEnable(true);
        this.navCompPlay.redoEnable(true);
        this.mainPanel.setPuzzle(this.puzzle);
        this.mainPanel.repaint();
        if (nextPuzzle == null) {
            this.navSingle.undoEnable(false);
            this.navCompPlay.undoEnable(false);
        }
        this.updateBars();
    }

    public void redo() {
        System.out.println("redo()");
        this.undoList.push(this.puzzle.clone());
        this.puzzle = this.redoList.pop();
        Puzzle nextPuzzle = this.redoList.peek();
        this.navSingle.undoEnable(true);
        this.navCompPlay.undoEnable(true);
        this.mainPanel.setPuzzle(this.puzzle);
        this.mainPanel.repaint();
        if (nextPuzzle == null) {
            this.navSingle.redoEnable(false);
            this.navCompPlay.redoEnable(false);
        }
        this.updateBars();
    }

    public void updateBars() {
        if (this.compMode.booleanValue()) {
            int complete = this.puzzle.getPercentageComplete();
            this.navCompPlay.setPlayerProgress(complete);
            boolean error = Hint.ErrorExists(this.puzzle);
            if (this.clientMachine.booleanValue()) {
                System.out.println("Report Client Complete: " + complete + " Errors: " + error);
                this.client.reportLocalStatus(complete, error);
            } else if (this.serverMachine.booleanValue()) {
                System.out.println("Report Server Complete: " + complete + " Errors: " + error);
                this.server.reportLocalStatus(complete, error);
            }
        }
    }

    public void changeMade() {
        System.out.println("DEPRECATED: changeMade() - PLEASE USE changeMade(Puzzle)");
    }

    public void changeMade(Puzzle old) {
        System.out.println("changeMade(Puzzle old)");
        int complete = this.puzzle.getPercentageComplete();
        this.resetHintLevel();
        this.redoList.clear();
        if (this.compMode.booleanValue()) {
            this.navCompPlay.undoEnable(true);
            this.navCompPlay.redoEnable(false);
            this.updateBars();
        } else {
            this.navSingle.undoEnable(true);
            this.navSingle.redoEnable(false);
        }
        if (complete == 100) {
            this.checkPuzzleCorrect();
        }
        this.undoList.push(old);
    }

    public void localPlayerLost() {
        System.out.println("Local Player has lost");
        this.mainPanel.repaint();
        this.cER = this.compEndDlg.showLost();
        this.doCER(this.cER);
    }

    public void checkPuzzleCorrect() {
        boolean errors = Hint.ErrorExists(this.puzzle);
        this.singEndDlg = new SingleEndDialog((Frame)this, this.puzzle);
        if (this.compMode.booleanValue()) {
            if (!errors) {
                this.mainPanel.repaint();
                this.navSingle.setTimer(false);
                this.cER = this.compEndDlg.showWon();
            } else if (errors) {
                this.mainPanel.repaint();
                this.cER = this.compEndDlg.showErrors();
            }
            this.doCER(this.cER);
        } else {
            if (!errors) {
                this.mainPanel.repaint();
                this.navSingle.setTimer(false);
                this.sER = this.singEndDlg.showWon();
            } else if (errors) {
                this.mainPanel.repaint();
                this.sER = this.singEndDlg.showErrors();
            }
            this.doSER(this.sER);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public Server getServer() {
        return this.server;
    }

    public void hostGame() {
        System.out.println("hostGame()");
        this.serverMachine = true;
        this.clientMachine = false;
        this.showNavCompHost();
        this.server.startHosting(this.puzzle);
        System.out.println("Hosting Started");
    }

    public void refreshJoinList(Vector<HostSummary> vhs) {
        this.client.getServerList(vhs);
    }

    public void cancelHosting() {
        System.out.println("Server: Cancel Hosting");
        this.server.cancelHosting();
    }

    public void beginCompetition() {
        this.showPuzzle(this.puzzle);
    }

    public void joinGame(String ip) {
        this.serverMachine = false;
        this.clientMachine = true;
        try {
            System.out.println(String.valueOf(ip) + ": Attempting to connect");
            Puzzle p = this.client.connectTo(InetAddress.getByName(ip));
            if (p == null) {
                System.out.println(String.valueOf(ip) + ": Puzzle not received");
                JOptionPane.showMessageDialog(this, "There was a problem connecting to the IP Address you entered.", "Connection Error!", 0);
                this.navCompJoin.setRefresh(true);
                this.navCompJoin.repaint();
            } else {
                System.out.println(String.valueOf(ip) + ": Puzzle Received");
                this.showPuzzle(p);
            }
        }
        catch (UnknownHostException u) {
            System.out.println("Unknown Host: " + ip + " Exception: " + u);
        }
    }

    public void joinGame(InetAddress ip) {
        this.serverMachine = false;
        this.clientMachine = true;
        System.out.println(ip + ": Attempting to connect");
        Puzzle p = this.client.connectTo(ip);
        if (p == null) {
            System.out.println(ip + ": Puzzle not received");
            JOptionPane.showMessageDialog(this, "There was a problem connecting to the host you selected.", "Connection Error!", 0);
            this.navCompJoin.setRefresh(true);
            this.navCompJoin.repaint();
        } else {
            System.out.println(ip + ": Puzzle Received");
            this.showPuzzle(p);
        }
    }

    public void connectionLost() {
        System.out.println("connectionLost()");
        if (this.serverMachine.booleanValue()) {
            System.out.println("Server: Cancel Hosting");
            this.server.cancelHosting();
        } else if (this.clientMachine.booleanValue()) {
            System.out.println("Client: Disconnecting");
            this.client.disconnect();
        }
        this.cER = this.compEndDlg.showConnectionLost();
        this.doCER(this.cER);
    }

    public void endGame() {
        System.out.println("endGame()");
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to end this game?", "End Game?", 0) == 0) {
            this.navSingle.setTimer(false);
            if (this.compMode.booleanValue()) {
                if (this.serverMachine.booleanValue()) {
                    System.out.println("Server: Cancel Hosting");
                    this.server.cancelHosting();
                } else if (this.clientMachine.booleanValue()) {
                    System.out.println("Client: Disconnecting");
                    this.client.disconnect();
                }
            } else if (this.singMode.booleanValue()) {
                this.setCustMode(false);
                this.navSingle.pausedEnd();
            }
            this.showNavMain();
        }
    }

    public void doCER(CompEndResult c) {
        block5: {
            block6: {
                block4: {
                    if (c != CompEndResult.END_SESSION) break block4;
                    this.hintPanel.hideButton();
                    this.navSingle.setTimer(false);
                    if (this.compMode.booleanValue()) {
                        if (this.serverMachine.booleanValue()) {
                            System.out.println("Server: Cancel Hosting");
                            this.server.cancelHosting();
                        } else if (this.clientMachine.booleanValue()) {
                            System.out.println("Client: Disconnecting");
                            this.client.disconnect();
                        }
                    }
                    this.showNavMain();
                    break block5;
                }
                if (c != CompEndResult.CONTINUE) break block6;
                this.setSingMode(true);
                this.showNavSingle();
                this.navSingle.setTimer(true);
                break block5;
            }
            if (c != CompEndResult.PLAY_AGAIN) break block5;
            this.showNavComp();
            this.hintPanel.hideButton();
        }
    }

    public void doSER(SingleEndResult s) {
        if (s == SingleEndResult.NEW_PUZZLE) {
            this.showNavSingle();
            this.resetSinglePanel();
            this.generatePuzzle();
            this.hintPanel.hideButton();
        } else if (s == SingleEndResult.RETURN_TO_GRID) {
            this.navSingle.setTimer(false);
        } else if (s != SingleEndResult.ERRORS_OK && s == SingleEndResult.END_GAME) {
            this.navSingle.setTimer(false);
            this.setCustMode(false);
            this.navSingle.pausedEnd();
            this.showNavMain();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.generate.booleanValue()) continue;
            System.out.println("Generating " + this.diff + " Puzzle!");
            this.navSingle.setTimer(false);
            this.puzzle = Generator.generate(this.diff);
            if (this.singMode.booleanValue()) {
                this.showPuzzle(this.puzzle);
            }
            if (this.compMode.booleanValue()) {
                this.hostGame();
            }
            this.generate = false;
        }
    }

    public void generatePuzzle(PuzzleDifficulty d) {
        this.diff = d;
        this.generate = true;
    }

    public void generatePuzzle() {
        this.generatePuzzle(this.diff);
    }

    public void showPuzzle(Puzzle p) {
        System.out.println("Show Puzzle");
        this.puzzle = p;
        this.resetHintLevel();
        this.saveRestore.clearFilename();
        this.puzzle.setHintsGiven(0);
        this.setPuzzleTime(0L);
        this.mainPanel.setPuzzle(this.puzzle);
        this.mainPanel.repaint();
        if (this.compMode.booleanValue()) {
            this.showNavCompPlay();
        }
        if (this.singMode.booleanValue()) {
            this.showNavSingle();
        }
        this.navSingle.setTimer(true);
        this.navDifficulty.waitingState(false);
    }

    public void disableHints() {
        this.hint_menu_item.setEnabled(false);
        this.navCompPlay.disableHintButton();
    }

    public void hintPanelVisible(Boolean on) {
        System.out.println("Competition Mode: " + this.compMode + " | Single Player: " + this.singMode);
        if (this.compMode.booleanValue() || this.singMode.booleanValue()) {
            this.hintPanel.setVisible(on);
        }
    }

    public int getHintLevel() {
        System.out.println(String.valueOf(this.hintLevel) + " Hint Level");
        return this.hintLevel;
    }

    public void resetHintLevel() {
        this.hintLevel = 0;
    }

    public int getHintsUsed() {
        int hints = this.puzzle.getHintsGiven();
        return hints;
    }

    public void hint() {
        this.hintPanelVisible(true);
        this.hintPanel.enableAndShow(true);
        ++this.hintLevel;
        System.out.println("hint()");
        int h = this.getHintsUsed();
        int hintsAllowed = 10;
        if (this.compMode.booleanValue()) {
            if (hintsAllowed == h + 1) {
                this.disableHints();
            } else {
                this.puzzle.setHintsGiven(++h);
                this.navCompPlay.updateHintDisplay(hintsAllowed);
            }
        }
        if (this.singMode.booleanValue()) {
            this.puzzle.setHintsGiven(++h);
            this.navSingle.updateHintDisplay();
        }
        this.hintPanel.setHintText(Hint.getHint(this.puzzle, this));
        this.mainPanel.repaint();
    }

    public void clearHintSelected() {
        System.out.println("clearHintSelected()");
        this.hintPanel.enableAndShow(false);
        this.puzzle.clearHintSelected();
        this.mainPanel.repaint();
    }

    public void finaliseCustom() {
        System.out.println("finaliseCustom()");
        if (Generator.checkValid(this.puzzle)) {
            this.setCustMode(true);
            this.mainPanel.setEditorMode(false);
            this.showNavSingle();
            this.redoList.clear();
            this.undoList.clear();
        } else {
            JOptionPane.showMessageDialog(this, "Sorry, the puzzle you just entered has no unique solution.\nPlease check you have entered it correctly.", "Error Detected!", 0);
        }
    }

    public void editCustomPuzzle() {
        Puzzle p;
        System.out.println("editCustomPuzzle()");
        this.showNavCustom();
        this.puzzle = p = new Puzzle(PuzzleDifficulty.NOT_RATED);
        this.mainPanel.setPuzzle(this.puzzle);
        this.mainPanel.setEditorMode(true);
        this.navSingle.setTimer(false);
    }

    public void cancelCustom() {
        this.redoList.clear();
        this.undoList.clear();
        this.mainPanel.setPuzzle(null);
        this.mainPanel.setEditorMode(false);
        this.showNavDifficulty();
    }

    public void singlePlayer() {
        System.out.println("singlePlayer()");
        this.showNavDifficulty();
        this.navDifficulty.setCustomOption(true);
    }

    public void hostCompetitionSetup() {
        System.out.println("competitionMode()");
        this.showNavDifficulty();
        this.navDifficulty.setCustomOption(false);
        this.serverMachine = true;
        this.clientMachine = false;
    }

    public void displayInstructions() {
        System.out.println("displayInstructions()");
        this.mainPanel.setDisplayInstructions(true);
        this.hintPanelVisible(false);
    }

    public void showAboutDialog() {
        System.out.println("showAboutDialog()");
        this.about.showAbout();
    }

    public void switchTimer() {
        System.out.println("switchTimer()");
        this.navSingle.toggleTimer();
    }

    public void resetCompPlayPanel() {
        System.out.println("resetCompPlayPanel()");
        this.hintPanelVisible(true);
        this.navCompPlay.resetPanel();
        this.navSingle.setTimer(true);
        this.navCompPlay.setPlayerProgress(0);
        this.navCompPlay.setOpponentProgress(0, false);
    }

    public void resetSinglePanel() {
        System.out.println("resetSinglePanel()");
        this.hintPanelVisible(true);
        this.saveRestore.clearFilename();
        this.navSingle.resetPanel();
        this.navSingle.setTimer(true);
    }

    public static void main(String[] args) {
        UIFrame uif = new UIFrame();
        uif.setMinimumSize(new Dimension(800, 600));
        uif.setVisible(true);
    }
}

