/*
 * Decompiled with CFR 0.152.
 */
package sudoku.game;

import sudoku.game.Hint;
import sudoku.game.Puzzle;
import sudoku.game.PuzzleDifficulty;
import sudoku.game.Solver;

public class Generator {
    Solver solver = new Solver();
    private boolean rotationalsymmetric = true;
    private int maxNumberOfGivens = 30;
    public static Thread collector;
    private static boolean collecting;
    private static boolean collectionSuccess;
    private static PuzzleDifficulty ourpd;
    private static final Puzzle blankPuzzle;
    private static Puzzle generatedFinal;
    private static Puzzle easyPuzzleHolder;
    private static Puzzle mildPuzzleHolder;
    private static Puzzle trickyPuzzleHolder;
    private static Puzzle difficultPuzzleHolder;
    private static Puzzle insanePuzzleHolder;
    private static boolean existEasy;
    private static boolean existMild;
    private static boolean existTricky;
    private static boolean existDifficult;
    private static boolean existInsane;

    static {
        collecting = false;
        collectionSuccess = false;
        blankPuzzle = new Puzzle(null);
        generatedFinal = new Puzzle(PuzzleDifficulty.NOT_RATED);
        easyPuzzleHolder = new Puzzle(PuzzleDifficulty.EASY);
        mildPuzzleHolder = new Puzzle(PuzzleDifficulty.MILD);
        trickyPuzzleHolder = new Puzzle(PuzzleDifficulty.TRICKY);
        difficultPuzzleHolder = new Puzzle(PuzzleDifficulty.DIFFICULT);
        insanePuzzleHolder = new Puzzle(PuzzleDifficulty.INSANE);
        existEasy = false;
        existMild = false;
        existTricky = false;
        existDifficult = false;
        existInsane = false;
    }

    private static void foundPuzzle(int input) {
        switch (input) {
            case 1: {
                existEasy = true;
            }
            case 2: {
                existMild = true;
            }
            case 3: {
                existTricky = true;
            }
            case 4: {
                existDifficult = true;
            }
            case 5: {
                existInsane = true;
            }
        }
    }

    private static void puzzleUsed(int input) {
        switch (input) {
            case 1: {
                existEasy = false;
            }
            case 2: {
                existMild = false;
            }
            case 3: {
                existTricky = false;
            }
            case 4: {
                existDifficult = false;
            }
            case 5: {
                existInsane = false;
            }
        }
    }

    private static Puzzle returnPuzzle(int input) {
        switch (input) {
            case 1: {
                return easyPuzzleHolder;
            }
            case 2: {
                return mildPuzzleHolder;
            }
            case 3: {
                return trickyPuzzleHolder;
            }
            case 4: {
                return difficultPuzzleHolder;
            }
            case 5: {
                return insanePuzzleHolder;
            }
        }
        return blankPuzzle;
    }

    private static void puzzleTransfer(int input, Puzzle p) {
        switch (input) {
            case 1: {
                easyPuzzleHolder = p;
            }
            case 2: {
                mildPuzzleHolder = p;
            }
            case 3: {
                trickyPuzzleHolder = p;
            }
            case 4: {
                difficultPuzzleHolder = p;
            }
            case 5: {
                insanePuzzleHolder = p;
            }
        }
    }

    private static void puzzleReset(int input) {
        switch (input) {
            case 1: {
                easyPuzzleHolder = blankPuzzle;
            }
            case 2: {
                mildPuzzleHolder = blankPuzzle;
            }
            case 3: {
                trickyPuzzleHolder = blankPuzzle;
            }
            case 4: {
                difficultPuzzleHolder = blankPuzzle;
            }
            case 5: {
                insanePuzzleHolder = blankPuzzle;
            }
        }
    }

    private static boolean checkPuzzleExist(int input) {
        switch (input) {
            case 1: {
                return existEasy;
            }
            case 2: {
                return existMild;
            }
            case 3: {
                return existTricky;
            }
            case 4: {
                return existDifficult;
            }
            case 5: {
                return existInsane;
            }
        }
        return false;
    }

    public static void exportPuzzle(int input, Puzzle p) {
        Generator.foundPuzzle(input);
        Generator.puzzleTransfer(input, p);
    }

    public static Puzzle importPuzzle(int input) {
        Generator.puzzleUsed(input);
        Puzzle p = Generator.returnPuzzle(input);
        Generator.puzzleReset(input);
        return p;
    }

    public static void setCollector() {
        collecting = true;
    }

    public static void setCollectionSuccess() {
        collectionSuccess = true;
    }

    public static boolean checkValid(Puzzle p) {
        boolean isValid = false;
        Generator gener = new Generator();
        gener.solver.convertFromPuzzle(p);
        gener.solver.solve();
        boolean uniqueFlag = gener.solver.checkIfUnique();
        boolean solutionFlag = gener.solver.checkIfHasSolution();
        isValid = uniqueFlag && solutionFlag;
        return isValid;
    }

    public static Puzzle generate(PuzzleDifficulty pd) {
        System.out.println("generator called");
        Generator gener = new Generator();
        if (pd == PuzzleDifficulty.EASY && Generator.checkPuzzleExist(1)) {
            System.out.println("Easyout");
            Puzzle p = easyPuzzleHolder;
            Generator.importPuzzle(1);
            return p;
        }
        if (pd == PuzzleDifficulty.MILD && Generator.checkPuzzleExist(2)) {
            System.out.println("mildout");
            Puzzle p = mildPuzzleHolder;
            Generator.importPuzzle(2);
            return p;
        }
        if (pd == PuzzleDifficulty.TRICKY && Generator.checkPuzzleExist(3)) {
            System.out.println("trickyout");
            Puzzle p = trickyPuzzleHolder;
            Generator.importPuzzle(3);
            return p;
        }
        if (pd == PuzzleDifficulty.DIFFICULT && Generator.checkPuzzleExist(4)) {
            System.out.println("difficultout");
            Puzzle p = difficultPuzzleHolder;
            Generator.importPuzzle(4);
            return p;
        }
        if (pd == PuzzleDifficulty.INSANE && Generator.checkPuzzleExist(5)) {
            System.out.println("insaneout");
            Puzzle p = insanePuzzleHolder;
            Generator.importPuzzle(5);
            return p;
        }
        boolean isSymmetric = gener.rotationalsymmetric;
        int numberOfGiven = 0;
        int tries = 1;
        while (tries < 499) {
            ++tries;
            if (isSymmetric) {
                gener.solver.produceSymmetric();
            } else {
                gener.solver.produce();
            }
            Puzzle candadate = gener.solver.convertToPuzzle();
            numberOfGiven = gener.solver.getNumberOfGivens();
            if (numberOfGiven <= gener.maxNumberOfGivens) {
                PuzzleDifficulty difficulty = Hint.rateDifficulty(candadate);
                if (difficulty == pd && numberOfGiven <= gener.maxNumberOfGivens) {
                    generatedFinal = candadate;
                    System.out.println("Puzzle Generated");
                    break;
                }
                if (difficulty == PuzzleDifficulty.EASY && !Generator.checkPuzzleExist(1)) {
                    Generator.exportPuzzle(1, candadate);
                    System.out.println("EasyRecorded");
                } else if (difficulty == PuzzleDifficulty.MILD && !Generator.checkPuzzleExist(2)) {
                    Generator.exportPuzzle(2, candadate);
                    System.out.println("MildRecorded");
                } else if (difficulty == PuzzleDifficulty.TRICKY && !Generator.checkPuzzleExist(3)) {
                    Generator.exportPuzzle(3, candadate);
                    System.out.println("TrickyRecorded");
                } else if (difficulty == PuzzleDifficulty.DIFFICULT && !Generator.checkPuzzleExist(4)) {
                    Generator.exportPuzzle(4, candadate);
                    System.out.println("DifficultRecorded");
                } else if (difficulty == PuzzleDifficulty.INSANE && !Generator.checkPuzzleExist(5)) {
                    Generator.exportPuzzle(5, candadate);
                    System.out.println("InsaneRecorded");
                }
            }
            if (tries == 498) {
                Puzzle p;
                if (pd == PuzzleDifficulty.MILD && Generator.checkPuzzleExist(1)) {
                    System.out.println("Easyout");
                    p = easyPuzzleHolder;
                    Generator.importPuzzle(1);
                    return p;
                }
                if (pd == PuzzleDifficulty.TRICKY && Generator.checkPuzzleExist(2)) {
                    System.out.println("mildout");
                    p = mildPuzzleHolder;
                    Generator.importPuzzle(2);
                    return p;
                }
                if (pd == PuzzleDifficulty.DIFFICULT && Generator.checkPuzzleExist(3)) {
                    System.out.println("trickyout");
                    p = trickyPuzzleHolder;
                    Generator.importPuzzle(3);
                    return p;
                }
                if (pd == PuzzleDifficulty.INSANE && Generator.checkPuzzleExist(4)) {
                    System.out.println("difficultout");
                    p = difficultPuzzleHolder;
                    Generator.importPuzzle(4);
                    return p;
                }
                System.out.println("regenerate easy");
                p = Generator.generate(PuzzleDifficulty.EASY);
                return p;
            }
            System.out.println("Try " + tries);
            numberOfGiven = 0;
        }
        generatedFinal.setDifficulty(pd);
        return generatedFinal;
    }

    public static Puzzle testgenerate(PuzzleDifficulty pd) {
        Puzzle generated = new Puzzle(pd);
        int tries = 1;
        while (tries < 99999) {
            Generator gener = new Generator();
            gener.create("");
            Puzzle candadate = gener.solver.convertToPuzzle();
            if (++tries != 100) continue;
            generated = candadate;
            break;
        }
        return generated;
    }

    public static Puzzle solve(Puzzle p) {
        System.out.println("Solver Called");
        Generator gener = new Generator();
        gener.solver.convertFromPuzzle(p);
        gener.solver.solve();
        Puzzle converted = gener.solver.convertSolutionToPuzzle();
        return converted;
    }

    public Puzzle convertToPuzzle() {
        int[][] puzzleArrays = this.getPuzzle();
        Puzzle converted = new Puzzle(PuzzleDifficulty.NOT_RATED);
        byte currentDigit = 0;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                currentDigit = (byte)puzzleArrays[i][j];
                if (currentDigit != 0) {
                    converted.setGiven(i, j, currentDigit);
                }
                ++j;
            }
            ++i;
        }
        return converted;
    }

    public void create(String stringPuzzle) {
        if (stringPuzzle.length() == 81) {
            this.solver.toArraysOfCells(stringPuzzle);
        } else if (this.rotationalsymmetric) {
            this.solver.produceSymmetric();
        } else {
            this.solver.produce();
        }
    }

    public static void print(Puzzle p) {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                boolean isGiven = p.getCell(i, j).getGiven();
                if (isGiven) {
                    byte currentDigit = p.getCell(i, j).getValue();
                    System.out.print(currentDigit);
                }
                System.out.print(0);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    int[][] solveInArrays() {
        this.solver.solve();
        return this.solver.getSolution();
    }

    public String getPuzzleString() {
        String tempasdasd = this.toStrings2(this.getPuzzle());
        return tempasdasd;
    }

    public int[][] getPuzzle() {
        return this.solver.getPuzzle();
    }

    String combineResult() {
        int[][] temp = this.solveInArrays();
        String result = this.toStrings2(temp);
        return result;
    }

    String toStrings2(int[][] array) {
        String result = "";
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                result = array[j][i] == 0 ? result.concat(".") : result.concat(Integer.valueOf(array[j][i]).toString());
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void toArraysOfCells(String input) {
        if (input.length() != 81) {
            return;
        }
        int[][] converted = new int[9][9];
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                char c = input.charAt(j * 9 + i);
                converted[i][j] = c >= '1' && c <= '9' ? c - 48 : 0;
                ++j;
            }
            ++i;
        }
        this.solver.toArraysOfCells(converted);
    }

    public int[][] toArrays(String input) {
        if (input.length() != 81) {
            int[][] blank = new int[9][9];
            return blank;
        }
        int[][] converted = new int[9][9];
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                char c = input.charAt(j * 9 + i);
                converted[i][j] = c >= '1' && c <= '9' ? c - 48 : 0;
                ++j;
            }
            ++i;
        }
        return converted;
    }

    int[][] toArray(String puzzle) {
        int[][] result = new int[9][9];
        int currentIndex = 0;
        while (currentIndex < puzzle.length()) {
            int currentRow = currentIndex / 9;
            int currentColumn = currentIndex % 9;
            char currentChar = puzzle.charAt(currentIndex);
            int currentDigit = currentChar == '.' ? 0 : currentChar - 48;
            result[currentRow][currentColumn] = currentDigit;
            ++currentIndex;
        }
        return result;
    }

    void printArray(int[][] a) {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                System.out.print(a[i][j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    String toStrings(int[][] array) {
        String result = "";
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                result = array[i][j] == 0 ? result.concat(".") : result.concat(Integer.valueOf(array[i][j]).toString());
                ++j;
            }
            ++i;
        }
        return result;
    }

    static String toStrings(int[] array) {
        String result = "";
        int i = 1;
        while (i < 81) {
            result = array[i] == 0 ? result.concat(".") : result.concat(Integer.valueOf(array[i]).toString());
            ++i;
        }
        return result;
    }

    boolean typeChecker(int[][] array) {
        boolean flag = false;
        if (array.length == 9) {
            int i = 0;
            while (i < 9) {
                if (array[i].length == 9) {
                    flag = true;
                }
                ++i;
            }
        }
        flag = true;
        return flag;
    }

    boolean typeChecker(String string) {
        boolean flag = false;
        string.length();
        return flag;
    }
}

