/*
 * Decompiled with CFR 0.152.
 */
package sudoku.game;

import java.util.HashSet;

class SudokuCell {
    private int cellValue = 0;
    private int row;
    private int column;
    private HashSet collection = new HashSet();
    private int collectionCount = 0;
    private boolean[] ImpossibleNumbers = new boolean[10];
    private int ImpossibleNumbersCount;
    private int[] rowsOfNumbersWhichAreInvalidForCurrentCell = new int[20];
    private int[] columnsOfNumbersWhichAreInvalidForCurrentCell = new int[20];
    private SudokuCell NextCell;

    public SudokuCell(int row, int column, SudokuCell nextCell) {
        this.row = row;
        this.column = column;
        this.NextCell = nextCell;
        this.clearAllImpossibleNumbers();
        this.findPositionsOfAllImpossibleNumbersFor(row, column);
    }

    public boolean hasNext() {
        boolean hasNext = false;
        if (this != null) {
            hasNext = true;
        }
        return hasNext;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getValue() {
        return this.cellValue;
    }

    public void setValue(int input) {
        this.cellValue = input;
    }

    boolean contains(int input) {
        Integer currentNumberConverted;
        int currentNumber = input;
        Integer currentDigit = currentNumberConverted = new Integer(currentNumber);
        return this.collection.contains(currentDigit);
    }

    void add(int input) {
        Integer currentNumberConverted;
        int currentNumber = input;
        Integer currentDigit = currentNumberConverted = new Integer(currentNumber);
        this.collection.add(currentDigit);
    }

    void remove(int input) {
        Integer currentNumberConverted;
        int currentNumber = input;
        Integer currentDigit = currentNumberConverted = new Integer(currentNumber);
        this.collection.remove(currentDigit);
    }

    public void setInvalidNumbersCount(int input) {
        this.ImpossibleNumbersCount = input;
    }

    public int getInvalidNumbersCount() {
        return this.ImpossibleNumbersCount;
    }

    public void increamentInvalidNumbersCount() {
        ++this.ImpossibleNumbersCount;
    }

    public int[] getInvalidRows() {
        return this.rowsOfNumbersWhichAreInvalidForCurrentCell;
    }

    public int[] getInvalidColumns() {
        return this.columnsOfNumbersWhichAreInvalidForCurrentCell;
    }

    public boolean[] getInvalidNumbersSet() {
        return this.ImpossibleNumbers;
    }

    public SudokuCell getNextCell() {
        return this.NextCell;
    }

    public boolean ifEqual(int input) {
        return this.cellValue == input;
    }

    public void clearAllImpossibleNumbers() {
        int i = 0;
        while (i < 10) {
            this.ImpossibleNumbers[i] = false;
            ++i;
        }
        this.ImpossibleNumbersCount = 0;
    }

    public void initialize() {
        this.collection.clear();
        this.collectionCount = 0;
    }

    public void findPositionsOfAllImpossibleNumbersFor(int row, int column) {
        int currentPointer = 0;
        int i = 0;
        while (i < 9) {
            if (i != column) {
                this.rowsOfNumbersWhichAreInvalidForCurrentCell[currentPointer] = row;
                this.columnsOfNumbersWhichAreInvalidForCurrentCell[currentPointer++] = i;
            }
            ++i;
        }
        i = 0;
        while (i < 9) {
            if (i != row) {
                this.rowsOfNumbersWhichAreInvalidForCurrentCell[currentPointer] = i;
                this.columnsOfNumbersWhichAreInvalidForCurrentCell[currentPointer++] = column;
            }
            ++i;
        }
        int horrizontalBlock = row / 3 * 3;
        int verticalBlock = column / 3 * 3;
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 3) {
                if (horrizontalBlock + i2 != row && verticalBlock + j != column) {
                    this.rowsOfNumbersWhichAreInvalidForCurrentCell[currentPointer] = horrizontalBlock + i2;
                    this.columnsOfNumbersWhichAreInvalidForCurrentCell[currentPointer++] = verticalBlock + j;
                }
                ++j;
            }
            ++i2;
        }
    }
}

