/*
 * Decompiled with CFR 0.152.
 */
package sudoku.data;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sudoku.game.Puzzle;
import sudoku.ui.DrawPuzzle;

public class Print {
    private static int requestedSize;
    private static int availWidth;
    private static int availHeight;
    private static Puzzle puzzle;

    public static void print(Puzzle p, int option) {
        puzzle = p.clone();
        puzzle.clearUserSelected();
        puzzle.clearHintSelected();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pf = printerJob.defaultPage();
        availWidth = (int)pf.getWidth();
        availHeight = (int)pf.getHeight();
        if (option == 0) {
            requestedSize = availWidth * 3 / 4;
        }
        if (option == 1) {
            requestedSize = availWidth / 2;
        }
        printerJob.setPrintable(new Printable(){

            public int print(Graphics g, PageFormat pf, int pi) {
                if (pi >= 1) {
                    return 1;
                }
                Graphics2D g2d = (Graphics2D)g;
                DrawPuzzle.draw(puzzle, g2d, requestedSize, availWidth, availHeight);
                return 0;
            }
        });
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }
}

