/*
 * Decompiled with CFR 0.152.
 */
package sudoku.game;

import sudoku.game.Generator;
import sudoku.game.Puzzle;
import sudoku.game.PuzzleDifficulty;
import sudoku.ui.UIFrame;

public class Hint {
    private static Boolean[][] HintCells = new Boolean[9][9];
    private static int HintRow;
    private static int HintColumn;
    private static int HintValue;
    private static int HintScribble;
    private static int RemainingCells;
    private static int HintCategory;
    private static int HintDifficulty;
    private static int ErrorCount;
    private static Puzzle q;
    private static boolean[][][] possibilities;
    private static boolean[][][] MasterPossibilities;
    private static boolean HintScribbleChange;
    private static boolean ForceChainValid;
    private static boolean ColouredChainValid;

    static {
        HintDifficulty = 0;
        ErrorCount = 0;
        q = new Puzzle(PuzzleDifficulty.NOT_RATED);
        possibilities = new boolean[9][9][9];
        MasterPossibilities = new boolean[9][9][9];
        HintScribbleChange = false;
        ForceChainValid = true;
        ColouredChainValid = true;
    }

    private Hint() {
    }

    public static String getHint(Puzzle p, UIFrame uiframe) {
        int level = uiframe.getHintLevel();
        String ReturnHint = "";
        Hint.ClearHintCells(p);
        if (Hint.Error(p)) {
            ReturnHint = Hint.HintMessage(0, level);
        } else if (Hint.ScribbleErrors(p).booleanValue()) {
            ReturnHint = Hint.HintMessage(5, level);
        } else if (Hint.NotUsingScribbles(p, level, uiframe)) {
            ReturnHint = Hint.HintMessage(7, level);
        } else {
            Hint.setPossibilities(p);
            MasterPossibilities = possibilities;
            HintCategory = 99;
            while (Hint.TrimMasterPossibilities(level) && !Hint.ChangeHelpsUser(p)) {
                Hint.ClearHintCells(p);
                HintCategory = 99;
            }
            if (HintCategory == 99) {
                Hint.FinalResortHint(p, level);
            }
            ReturnHint = Hint.HintMessage(HintCategory, level);
        }
        if (level > 1) {
            Hint.SetHintCells(p);
        }
        if (level >= 3) {
            Hint.RevealValue(p, uiframe);
        }
        return ReturnHint;
    }

    private static boolean TrimMasterPossibilities(int level) {
        Hint.SetHintDifficulty(1);
        if (Hint.MasterNakedSingle()) {
            return true;
        }
        Hint.SetHintDifficulty(2);
        if (Hint.MasterHiddenSingle()) {
            return true;
        }
        Hint.SetHintDifficulty(3);
        if (Hint.MasterBlockRow(level)) {
            return true;
        }
        if (Hint.MasterBlockColumn(level)) {
            return true;
        }
        if (Hint.MasterBlockBlock(level)) {
            return true;
        }
        if (Hint.MasterNakedSubset(2, level)) {
            return true;
        }
        if (Hint.MasterNakedSubset(3, level)) {
            return true;
        }
        Hint.SetHintDifficulty(4);
        if (Hint.MasterNakedSubset(4, level)) {
            return true;
        }
        if (Hint.MasterNakedSubset(5, level)) {
            return true;
        }
        if (Hint.MasterNakedSubset(6, level)) {
            return true;
        }
        if (Hint.MasterNakedSubset(7, level)) {
            return true;
        }
        if (Hint.MasterNakedSubset(8, level)) {
            return true;
        }
        if (Hint.XWing(level)) {
            return true;
        }
        if (Hint.XYWing(level)) {
            return true;
        }
        Hint.SetHintDifficulty(5);
        if (Hint.MasterForcingChains(level)) {
            return true;
        }
        return Hint.MasterColouring(level);
    }

    private static boolean ChangeHelpsUser(Puzzle p) {
        if (HintValue != 0) {
            return true;
        }
        return p.getCell(HintRow, HintColumn).getScribble(HintScribble);
    }

    private static boolean MasterNakedSingle() {
        int count = 0;
        int value = 0;
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                count = 0;
                int c = 0;
                while (c < 9) {
                    if (MasterPossibilities[a][b][c]) {
                        value = c;
                        ++count;
                    }
                    ++c;
                }
                if (count == 1) {
                    Hint.HintCells[a][b] = true;
                    HintValue = value + 1;
                    HintRow = a;
                    HintColumn = b;
                    HintCategory = 1;
                    HintScribbleChange = false;
                    return true;
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static boolean MasterHiddenSingle() {
        int c;
        int count = 0;
        int column = 0;
        int row = 0;
        int a = 0;
        while (a < 9) {
            c = 0;
            while (c < 9) {
                count = 0;
                int b = 0;
                while (b < 9) {
                    if (MasterPossibilities[a][b][c]) {
                        ++count;
                        column = b;
                    }
                    ++b;
                }
                if (count == 1) {
                    Hint.HintCells[a][column] = true;
                    HintRow = a;
                    HintColumn = column;
                    HintValue = c + 1;
                    HintCategory = 2;
                    HintScribbleChange = false;
                    return true;
                }
                ++c;
            }
            ++a;
        }
        int b = 0;
        while (b < 9) {
            c = 0;
            while (c < 9) {
                count = 0;
                int a2 = 0;
                while (a2 < 9) {
                    if (MasterPossibilities[a2][b][c]) {
                        ++count;
                        row = a2;
                    }
                    ++a2;
                }
                if (count == 1) {
                    Hint.HintCells[row][b] = true;
                    HintRow = row;
                    HintColumn = b;
                    HintValue = c + 1;
                    HintCategory = 2;
                    HintScribbleChange = false;
                    return true;
                }
                ++c;
            }
            ++b;
        }
        a = 0;
        while (a < 3) {
            int i = 3 * a;
            int b2 = 0;
            while (b2 < 3) {
                int j = 3 * b2;
                int c2 = 0;
                while (c2 < 9) {
                    count = 0;
                    int d = i;
                    while (d < i + 3) {
                        int e = j;
                        while (e < j + 3) {
                            if (MasterPossibilities[d][e][c2]) {
                                ++count;
                                row = d;
                                column = e;
                            }
                            ++e;
                        }
                        ++d;
                    }
                    if (count == 1) {
                        Hint.HintCells[row][column] = true;
                        HintRow = row;
                        HintColumn = column;
                        HintValue = c2 + 1;
                        HintCategory = 2;
                        HintScribbleChange = false;
                        return true;
                    }
                    ++c2;
                }
                ++b2;
            }
            ++a;
        }
        return false;
    }

    private static boolean MasterBlockRow(int level) {
        int RowCount = 0;
        int row = 0;
        boolean InRow = false;
        int a = 0;
        while (a < 3) {
            int i = 3 * a;
            int b = 0;
            while (b < 3) {
                int j = 3 * b;
                int c = 0;
                while (c < 9) {
                    RowCount = 0;
                    int d = i;
                    while (d < i + 3) {
                        InRow = false;
                        int e = j;
                        while (e < j + 3) {
                            if (MasterPossibilities[d][e][c]) {
                                InRow = true;
                                row = d;
                            }
                            ++e;
                        }
                        if (InRow) {
                            ++RowCount;
                        }
                        ++d;
                    }
                    if (RowCount == 1) {
                        int f = 0;
                        while (f < 9) {
                            if (MasterPossibilities[row][f][c] && (f < j || f >= j + 3)) {
                                Hint.HintCells[row][f] = true;
                                if (level < 3) {
                                    int d2 = i;
                                    while (d2 < i + 3) {
                                        int e = j;
                                        while (e < j + 3) {
                                            Hint.HintCells[d2][e] = true;
                                            ++e;
                                        }
                                        ++d2;
                                    }
                                }
                                HintRow = row;
                                HintColumn = f;
                                HintValue = 0;
                                HintScribble = c;
                                HintScribbleChange = true;
                                HintCategory = 6;
                                Hint.MasterPossibilities[row][f][c] = false;
                                return true;
                            }
                            ++f;
                        }
                    }
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static boolean MasterBlockColumn(int level) {
        int ColumnCount = 0;
        int Column = 0;
        boolean InColumn = false;
        int a = 0;
        while (a < 3) {
            int i = 3 * a;
            int b = 0;
            while (b < 3) {
                int j = 3 * b;
                int c = 0;
                while (c < 9) {
                    ColumnCount = 0;
                    int d = i;
                    while (d < i + 3) {
                        InColumn = false;
                        int e = j;
                        while (e < j + 3) {
                            if (MasterPossibilities[e][d][c]) {
                                InColumn = true;
                                Column = d;
                            }
                            ++e;
                        }
                        if (InColumn) {
                            ++ColumnCount;
                        }
                        ++d;
                    }
                    if (ColumnCount == 1) {
                        int f = 0;
                        while (f < 9) {
                            if (MasterPossibilities[f][Column][c] && (f < j || f >= j + 3)) {
                                Hint.HintCells[f][Column] = true;
                                if (level < 3) {
                                    int d2 = i;
                                    while (d2 < i + 3) {
                                        int e = j;
                                        while (e < j + 3) {
                                            Hint.HintCells[e][d2] = true;
                                            ++e;
                                        }
                                        ++d2;
                                    }
                                }
                                HintRow = f;
                                HintColumn = Column;
                                HintValue = 0;
                                HintScribble = c;
                                HintScribbleChange = true;
                                HintCategory = 6;
                                Hint.MasterPossibilities[f][Column][c] = false;
                                return true;
                            }
                            ++f;
                        }
                    }
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static boolean MasterBlockBlock(int level) {
        if (Hint.MasterBlockBlockRows(level)) {
            return true;
        }
        return Hint.MasterBlockBlockCols(level);
    }

    private static boolean MasterBlockBlockRows(int level) {
        int a = 0;
        while (a < 2) {
            int i = 3 * a;
            int b = 0;
            while (b < 3) {
                int j = 3 * b;
                int c = a + 1;
                while (c < 3) {
                    int k = 3 * c;
                    int z = 0;
                    while (z < 9) {
                        int e;
                        int row1_1 = 0;
                        int row1_2 = 0;
                        int row2_1 = 0;
                        int row2_2 = 0;
                        boolean found1 = false;
                        boolean found2 = false;
                        boolean found3 = false;
                        int d = j;
                        while (d < j + 3) {
                            e = i;
                            while (e < i + 3) {
                                if (!found1 && MasterPossibilities[d][e][z]) {
                                    found1 = true;
                                    row1_1 = d;
                                }
                                if (found1 && !found2 && row1_1 != d && MasterPossibilities[d][e][z]) {
                                    found2 = true;
                                    row2_1 = d;
                                }
                                if (found1 && found2 && row2_1 != d && MasterPossibilities[d][e][z]) {
                                    found3 = true;
                                }
                                ++e;
                            }
                            ++d;
                        }
                        if (!found3 && found2) {
                            found1 = false;
                            found2 = false;
                            found3 = false;
                            d = j;
                            while (d < j + 3) {
                                e = k;
                                while (e < k + 3) {
                                    if (!found1 && MasterPossibilities[d][e][z]) {
                                        found1 = true;
                                        row1_2 = d;
                                    }
                                    if (found1 && !found2 && row1_1 != d && MasterPossibilities[d][e][z]) {
                                        found2 = true;
                                        row2_2 = d;
                                    }
                                    if (found1 && found2 && row2_1 != d && MasterPossibilities[d][e][z]) {
                                        found3 = true;
                                    }
                                    ++e;
                                }
                                ++d;
                            }
                            if (found2 && !found3 && row1_1 == row1_2 && row2_1 == row2_2) {
                                int s;
                                int h;
                                int f = row1_1;
                                int g = 0;
                                while (g < 9) {
                                    if (!(!MasterPossibilities[f][g][z] || g >= i && g < i + 3 || g >= k && g < k + 3)) {
                                        Hint.HintCells[f][g] = true;
                                        if (level < 3) {
                                            h = j;
                                            while (h < j + 3) {
                                                int r = i;
                                                while (r < i + 3) {
                                                    Hint.HintCells[h][r] = true;
                                                    ++r;
                                                }
                                                ++h;
                                            }
                                            s = j;
                                            while (s < j + 3) {
                                                int t = k;
                                                while (t < k + 3) {
                                                    Hint.HintCells[s][t] = true;
                                                    ++t;
                                                }
                                                ++s;
                                            }
                                        }
                                        HintValue = 0;
                                        HintRow = f;
                                        HintColumn = g;
                                        HintScribble = z;
                                        HintScribbleChange = true;
                                        HintCategory = 8;
                                        Hint.MasterPossibilities[f][g][z] = false;
                                        return true;
                                    }
                                    ++g;
                                }
                                f = row2_1;
                                g = 0;
                                while (g < 9) {
                                    if (!(!MasterPossibilities[f][g][z] || g >= i && g < i + 3 || g >= k && g < k + 3)) {
                                        Hint.HintCells[f][g] = true;
                                        if (level < 3) {
                                            h = j;
                                            while (h < j + 3) {
                                                int r = i;
                                                while (r < i + 3) {
                                                    Hint.HintCells[h][r] = true;
                                                    ++r;
                                                }
                                                ++h;
                                            }
                                            s = j;
                                            while (s < j + 3) {
                                                int t = k;
                                                while (t < k + 3) {
                                                    Hint.HintCells[s][t] = true;
                                                    ++t;
                                                }
                                                ++s;
                                            }
                                        }
                                        HintValue = 0;
                                        HintRow = f;
                                        HintColumn = g;
                                        HintScribble = z;
                                        HintScribbleChange = true;
                                        HintCategory = 8;
                                        Hint.MasterPossibilities[f][g][z] = false;
                                        return true;
                                    }
                                    ++g;
                                }
                            }
                        }
                        ++z;
                    }
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static boolean MasterForcingChains(int level) {
        int count = 0;
        int value1 = 0;
        int value2 = 0;
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                count = 0;
                int c = 0;
                while (c < 9) {
                    if (MasterPossibilities[a][b][c]) {
                        if (++count == 1) {
                            value1 = c;
                        }
                        if (count == 2) {
                            value2 = c;
                        }
                    }
                    ++c;
                }
                if (count == 2) {
                    ForceChainValid = true;
                    int[][] array1 = Hint.forcechains(new int[9][9], a, b, value1);
                    if (!ForceChainValid) {
                        Hint.HintCells[a][b] = true;
                        HintRow = a;
                        HintColumn = b;
                        HintValue = 0;
                        HintScribble = value1;
                        HintCategory = 22;
                        HintScribbleChange = true;
                        Hint.MasterPossibilities[a][b][value1] = false;
                        return true;
                    }
                    ForceChainValid = true;
                    int[][] array2 = Hint.forcechains(new int[9][9], a, b, value2);
                    if (!ForceChainValid) {
                        Hint.HintCells[a][b] = true;
                        HintRow = a;
                        HintColumn = b;
                        HintValue = 0;
                        HintScribble = value2;
                        HintCategory = 22;
                        HintScribbleChange = true;
                        Hint.MasterPossibilities[a][b][value2] = false;
                        return true;
                    }
                    int i = 0;
                    while (i < 9) {
                        int j = 0;
                        while (j < 9) {
                            if (array1[i][j] == array2[i][j] && array1[i][j] != 0) {
                                int value = array1[i][j];
                                Hint.HintCells[j][i] = true;
                                if (level < 3) {
                                    Hint.HintCells[a][b] = true;
                                }
                                HintValue = value;
                                HintRow = j;
                                HintColumn = i;
                                HintCategory = 21;
                                HintScribbleChange = false;
                                return true;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static int numOfScribbles(int a, int b) {
        int count = 0;
        int c = 0;
        while (c < 9) {
            if (MasterPossibilities[a][b][c]) {
                ++count;
            }
            ++c;
        }
        return count;
    }

    private static int[][] forcechains(int[][] array, int a, int b, int c) {
        if (array[b][a] == 0) {
            int e;
            array[b][a] = c + 1;
            int f = 0;
            while (f < 9) {
                if (f != a && Hint.numOfScribbles(f, b) == 2 && MasterPossibilities[f][b][c]) {
                    e = 0;
                    while (e < 9) {
                        if (MasterPossibilities[f][b][e] && e != c) {
                            Hint.forcechains(array, f, b, e);
                            break;
                        }
                        ++e;
                    }
                }
                ++f;
            }
            int d = 0;
            while (d < 9) {
                if (d != b && Hint.numOfScribbles(a, d) == 2 && MasterPossibilities[a][d][c]) {
                    e = 0;
                    while (e < 9) {
                        if (MasterPossibilities[a][d][e] && e != c) {
                            Hint.forcechains(array, a, d, e);
                            break;
                        }
                        ++e;
                    }
                }
                ++d;
            }
            int ablock = a / 3 * 3;
            int bblock = b / 3 * 3;
            int g = ablock;
            while (g < ablock + 3) {
                int h = bblock;
                while (h < bblock + 3) {
                    if ((g != a || h != b) && Hint.numOfScribbles(g, h) == 2 && MasterPossibilities[g][h][c]) {
                        int e2 = 0;
                        while (e2 < 9) {
                            if (MasterPossibilities[g][h][e2] && e2 != c) {
                                Hint.forcechains(array, g, h, e2);
                                break;
                            }
                            ++e2;
                        }
                    }
                    ++h;
                }
                ++g;
            }
        } else if (array[b][a] != c + 1) {
            ForceChainValid = false;
        }
        return array;
    }

    public static void display(int[][] p) {
        int j = 0;
        while (j <= 8) {
            String s = "";
            int i = 0;
            while (i <= 8) {
                s = String.valueOf(s) + p[j][i] + " ";
                ++i;
            }
            System.out.println(s);
            ++j;
        }
    }

    private static boolean MasterColouring(int level) {
        int count = 0;
        int count2 = 0;
        int value1 = 0;
        int value2 = 0;
        int c = 0;
        while (c < 9) {
            int a = 0;
            while (a < 9) {
                count = 0;
                int b = 0;
                while (b < 9) {
                    if (MasterPossibilities[a][b][c]) {
                        if (++count == 1) {
                            value1 = b;
                        }
                        if (count == 2) {
                            value2 = b;
                        }
                    }
                    ++b;
                }
                if (count == 2) {
                    int jj;
                    int ii;
                    int j;
                    ForceChainValid = true;
                    int[][] array1 = Hint.forceColouredChains(new int[9][9], a, value1, c, 1);
                    int i = 0;
                    while (i < 9) {
                        count2 = 0;
                        j = 0;
                        while (j < 9) {
                            if (array1[i][j] == 1) {
                                ++count2;
                            }
                            ++j;
                        }
                        if (count2 > 1) {
                            ii = 0;
                            while (ii < 9) {
                                jj = 0;
                                while (jj < 9) {
                                    if ((array1[ii][jj] == 1 || array1[ii][jj] == 2) && level < 3) {
                                        Hint.HintCells[jj][ii] = true;
                                    }
                                    if (array1[ii][jj] == 2) {
                                        HintRow = jj;
                                        HintColumn = ii;
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            Hint.HintCells[Hint.HintRow][Hint.HintColumn] = true;
                            HintValue = c + 1;
                            HintCategory = 23;
                            HintScribbleChange = false;
                            return true;
                        }
                        count2 = 0;
                        j = 0;
                        while (j < 9) {
                            if (array1[i][j] == 2) {
                                ++count2;
                            }
                            ++j;
                        }
                        if (count2 > 1) {
                            ii = 0;
                            while (ii < 9) {
                                jj = 0;
                                while (jj < 9) {
                                    if ((array1[ii][jj] == 1 || array1[ii][jj] == 2) && level < 3) {
                                        Hint.HintCells[jj][ii] = true;
                                    }
                                    if (array1[ii][jj] == 1) {
                                        HintRow = jj;
                                        HintColumn = ii;
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            Hint.HintCells[Hint.HintRow][Hint.HintColumn] = true;
                            HintValue = c + 1;
                            HintCategory = 23;
                            HintScribbleChange = false;
                            return true;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < 9) {
                        count2 = 0;
                        j = 0;
                        while (j < 9) {
                            if (array1[j][i] == 1) {
                                ++count2;
                            }
                            ++j;
                        }
                        if (count2 > 1) {
                            ii = 0;
                            while (ii < 9) {
                                jj = 0;
                                while (jj < 9) {
                                    if ((array1[ii][jj] == 1 || array1[ii][jj] == 2) && level < 3) {
                                        Hint.HintCells[jj][ii] = true;
                                    }
                                    if (array1[ii][jj] == 2) {
                                        HintRow = jj;
                                        HintColumn = ii;
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            Hint.HintCells[Hint.HintRow][Hint.HintColumn] = true;
                            HintValue = c + 1;
                            HintCategory = 23;
                            HintScribbleChange = false;
                            return true;
                        }
                        count2 = 0;
                        j = 0;
                        while (j < 9) {
                            if (array1[j][i] == 2) {
                                ++count2;
                            }
                            ++j;
                        }
                        if (count2 > 1) {
                            ii = 0;
                            while (ii < 9) {
                                jj = 0;
                                while (jj < 9) {
                                    if ((array1[ii][jj] == 1 || array1[ii][jj] == 2) && level < 3) {
                                        Hint.HintCells[jj][ii] = true;
                                    }
                                    if (array1[ii][jj] == 1) {
                                        HintRow = jj;
                                        HintColumn = ii;
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            Hint.HintCells[Hint.HintRow][Hint.HintColumn] = true;
                            HintValue = c + 1;
                            HintCategory = 23;
                            HintScribbleChange = false;
                            return true;
                        }
                        ++i;
                    }
                    int k = 0;
                    while (k <= 6) {
                        int j2;
                        count2 = 0;
                        int i2 = k;
                        while (i2 < 3) {
                            j2 = k;
                            while (j2 < 3) {
                                if (array1[i2][k] == 1) {
                                    ++count2;
                                }
                                ++j2;
                            }
                            ++i2;
                        }
                        if (count2 > 1) {
                            ii = 0;
                            while (ii < 9) {
                                jj = 0;
                                while (jj < 9) {
                                    if ((array1[ii][jj] == 1 || array1[ii][jj] == 2) && level < 3) {
                                        Hint.HintCells[jj][ii] = true;
                                    }
                                    if (array1[ii][jj] == 2) {
                                        HintRow = jj;
                                        HintColumn = ii;
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            Hint.HintCells[Hint.HintRow][Hint.HintColumn] = true;
                            HintValue = c + 1;
                            HintCategory = 23;
                            HintScribbleChange = false;
                            return true;
                        }
                        count2 = 0;
                        i2 = k;
                        while (i2 < 3) {
                            j2 = k;
                            while (j2 < 3) {
                                if (array1[i2][k] == 2) {
                                    ++count2;
                                }
                                ++j2;
                            }
                            ++i2;
                        }
                        if (count2 > 1) {
                            ii = 0;
                            while (ii < 9) {
                                jj = 0;
                                while (jj < 9) {
                                    if ((array1[ii][jj] == 1 || array1[ii][jj] == 2) && level < 3) {
                                        Hint.HintCells[jj][ii] = true;
                                    }
                                    if (array1[ii][jj] == 1) {
                                        HintRow = jj;
                                        HintColumn = ii;
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            Hint.HintCells[Hint.HintRow][Hint.HintColumn] = true;
                            HintValue = c + 1;
                            HintCategory = 23;
                            HintScribbleChange = false;
                            return true;
                        }
                        k += 3;
                    }
                    i = 0;
                    while (i < 9) {
                        j = 0;
                        while (j < 9) {
                            int v = array1[i][j];
                            System.out.println(String.valueOf(i) + j + v);
                            if (MasterPossibilities[j][i][c] && v == 0) {
                                boolean cross2;
                                System.out.println("checking" + i + j + v);
                                boolean inRow1 = Hint.findinRow(array1, 1, i, j);
                                boolean inCol1 = Hint.findinCol(array1, 1, i, j);
                                boolean inBlock1 = Hint.findinBlock(array1, 1, i, j);
                                boolean cross1 = inRow1 || inCol1 || inBlock1;
                                boolean inRow2 = Hint.findinRow(array1, 2, i, j);
                                boolean inCol2 = Hint.findinCol(array1, 2, i, j);
                                boolean inBlock2 = Hint.findinBlock(array1, 2, i, j);
                                boolean bl = cross2 = inRow2 || inCol2 || inBlock2;
                                if (cross1 && cross2) {
                                    System.out.println("found scribble to eliminate !! hurray! at " + i + j);
                                    int ii2 = 0;
                                    while (ii2 < 9) {
                                        int jj2 = 0;
                                        while (jj2 < 9) {
                                            if ((array1[ii2][jj2] == 1 || array1[ii2][jj2] == 2) && level < 3) {
                                                Hint.HintCells[jj2][ii2] = true;
                                            }
                                            ++jj2;
                                        }
                                        ++ii2;
                                    }
                                    Hint.HintCells[j][i] = true;
                                    HintRow = j;
                                    HintColumn = i;
                                    HintValue = 0;
                                    HintScribble = c;
                                    HintCategory = 24;
                                    HintScribbleChange = true;
                                    Hint.MasterPossibilities[j][i][c] = false;
                                    return true;
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                ++a;
            }
            ++c;
        }
        return false;
    }

    private static boolean findinRow(int[][] array, int v, int a, int b) {
        int c = 0;
        while (c < 9) {
            if (c != b && array[a][c] == v) {
                return true;
            }
            ++c;
        }
        return false;
    }

    private static boolean findinCol(int[][] array, int v, int a, int b) {
        int r = 0;
        while (r < 9) {
            if (r != a && array[r][b] == v) {
                return true;
            }
            ++r;
        }
        return false;
    }

    private static boolean findinBlock(int[][] array, int v, int a, int b) {
        int ablock = a / 3 * 3;
        int bblock = b / 3 * 3;
        int i = ablock;
        while (i < ablock + 3) {
            int j = bblock;
            while (j < bblock + 3) {
                if ((i != a || j != b) && array[i][j] == v) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static int[][] forceColouredChains(int[][] array, int a, int b, int c, int chain) {
        int count = 0;
        int value = 0;
        int value1 = 0;
        int value2 = 0;
        if (array[b][a] == 0) {
            array[b][a] = chain;
            count = 0;
            int f = 0;
            while (f < 9) {
                if (f != a && MasterPossibilities[f][b][c] && ++count == 1) {
                    value = f;
                }
                ++f;
            }
            if (count == 1) {
                if (chain == 1) {
                    Hint.forceColouredChains(array, value, b, c, 2);
                } else if (chain == 2) {
                    Hint.forceColouredChains(array, value, b, c, 1);
                }
            }
            count = 0;
            int d = 0;
            while (d < 9) {
                if (d != b && MasterPossibilities[a][d][c] && ++count == 1) {
                    value = d;
                }
                ++d;
            }
            if (count == 1) {
                if (chain == 1) {
                    Hint.forceColouredChains(array, a, value, c, 2);
                } else if (chain == 2) {
                    Hint.forceColouredChains(array, a, value, c, 1);
                }
            }
            count = 0;
            int ablock = a / 3 * 3;
            int bblock = b / 3 * 3;
            int g = ablock;
            while (g < ablock + 3) {
                int h = bblock;
                while (h < bblock + 3) {
                    if ((g != a || h != b) && MasterPossibilities[g][h][c] && ++count == 1) {
                        value1 = g;
                        value2 = h;
                    }
                    ++h;
                }
                ++g;
            }
            if (count == 1) {
                if (chain == 1) {
                    Hint.forceColouredChains(array, value1, value2, c, 2);
                } else if (chain == 2) {
                    Hint.forceColouredChains(array, value1, value2, c, 1);
                }
            }
        } else if (array[b][a] != chain) {
            ForceChainValid = false;
        }
        return array;
    }

    private static boolean MasterBlockBlockCols(int level) {
        int a = 0;
        while (a < 2) {
            int i = 3 * a;
            int b = 0;
            while (b < 3) {
                int j = 3 * b;
                int c = a + 1;
                while (c < 3) {
                    int k = 3 * c;
                    int z = 0;
                    while (z < 9) {
                        int e;
                        int col1_1 = 0;
                        int col1_2 = 0;
                        int col2_1 = 0;
                        int col2_2 = 0;
                        boolean found1 = false;
                        boolean found2 = false;
                        boolean found3 = false;
                        int d = j;
                        while (d < j + 3) {
                            e = i;
                            while (e < i + 3) {
                                if (!found1 && MasterPossibilities[e][d][z]) {
                                    found1 = true;
                                    col1_1 = d;
                                }
                                if (found1 && !found2 && col1_1 != d && MasterPossibilities[e][d][z]) {
                                    found2 = true;
                                    col2_1 = d;
                                }
                                if (found1 && found2 && col2_1 != d && MasterPossibilities[e][d][z]) {
                                    found3 = true;
                                }
                                ++e;
                            }
                            ++d;
                        }
                        if (!found3 && found2) {
                            found1 = false;
                            found2 = false;
                            found3 = false;
                            d = j;
                            while (d < j + 3) {
                                e = k;
                                while (e < k + 3) {
                                    if (!found1 && MasterPossibilities[e][d][z]) {
                                        found1 = true;
                                        col1_2 = d;
                                    }
                                    if (found1 && !found2 && col1_1 != d && MasterPossibilities[e][d][z]) {
                                        found2 = true;
                                        col2_2 = d;
                                    }
                                    if (found1 && found2 && col2_1 != d && MasterPossibilities[e][d][z]) {
                                        found3 = true;
                                    }
                                    ++e;
                                }
                                ++d;
                            }
                            if (found2 && !found3 && col1_1 == col1_2 && col2_1 == col2_2) {
                                int s;
                                int h;
                                int f = col1_1;
                                int g = 0;
                                while (g < 9) {
                                    if (!(!MasterPossibilities[g][f][z] || g >= i && g < i + 3 || g >= k && g < k + 3)) {
                                        Hint.HintCells[g][f] = true;
                                        if (level < 3) {
                                            h = j;
                                            while (h < j + 3) {
                                                int r = i;
                                                while (r < i + 3) {
                                                    Hint.HintCells[r][h] = true;
                                                    ++r;
                                                }
                                                ++h;
                                            }
                                            s = j;
                                            while (s < j + 3) {
                                                int t = k;
                                                while (t < k + 3) {
                                                    Hint.HintCells[t][s] = true;
                                                    ++t;
                                                }
                                                ++s;
                                            }
                                        }
                                        HintValue = 0;
                                        HintRow = g;
                                        HintColumn = f;
                                        HintScribble = z;
                                        HintScribbleChange = true;
                                        HintCategory = 8;
                                        Hint.MasterPossibilities[g][f][z] = false;
                                        return true;
                                    }
                                    ++g;
                                }
                                f = col2_1;
                                g = 0;
                                while (g < 9) {
                                    if (!(!MasterPossibilities[g][f][z] || g >= i && g < i + 3 || g >= k && g < k + 3)) {
                                        Hint.HintCells[g][f] = true;
                                        if (level < 3) {
                                            h = j;
                                            while (h < j + 3) {
                                                int r = i;
                                                while (r < i + 3) {
                                                    Hint.HintCells[r][h] = true;
                                                    ++r;
                                                }
                                                ++h;
                                            }
                                            s = j;
                                            while (s < j + 3) {
                                                int t = k;
                                                while (t < k + 3) {
                                                    Hint.HintCells[t][s] = true;
                                                    ++t;
                                                }
                                                ++s;
                                            }
                                        }
                                        HintValue = 0;
                                        HintRow = g;
                                        HintColumn = f;
                                        HintScribble = z;
                                        HintScribbleChange = true;
                                        HintCategory = 8;
                                        Hint.MasterPossibilities[g][f][z] = false;
                                        return true;
                                    }
                                    ++g;
                                }
                            }
                        }
                        ++z;
                    }
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static boolean MasterNakedSubset(int size, int level) {
        if (Hint.MasterNakedSubsetInRow(size, level)) {
            return true;
        }
        if (Hint.MasterNakedSubsetInColumn(size, level)) {
            return true;
        }
        return Hint.MasterNakedSubsetInBlock(size, level);
    }

    private static boolean MasterNakedSubsetInRow(int size, int level) {
        boolean[] ValueUsed = new boolean[9];
        boolean CounterOkay = false;
        boolean CounterOkay2 = true;
        int[] counter = new int[size];
        int usedcount = 0;
        int row = 0;
        while (row < 9) {
            int n = -1;
            int z = size - 1;
            while (z >= 0) {
                counter[++n] = z--;
            }
            while (counter[0] != 9 && CounterOkay2) {
                CounterOkay = false;
                while (!CounterOkay && counter[0] != 9) {
                    CounterOkay = true;
                    int t = 0;
                    while (t < size) {
                        if (Hint.MasterCellPossibilities(row, counter[t]) == 0) {
                            CounterOkay = false;
                        }
                        ++t;
                    }
                    if (CounterOkay) continue;
                    Hint.GetNextCounter(counter, size);
                }
                if (counter[0] == 9) continue;
                int y = 0;
                while (y < 9) {
                    ValueUsed[y] = false;
                    ++y;
                }
                int x = 0;
                while (x < size) {
                    int w = 0;
                    while (w < 9) {
                        if (MasterPossibilities[row][counter[x]][w]) {
                            ValueUsed[w] = true;
                        }
                        ++w;
                    }
                    ++x;
                }
                usedcount = 0;
                y = 0;
                while (y < 9) {
                    if (ValueUsed[y]) {
                        ++usedcount;
                    }
                    ++y;
                }
                if (usedcount == size) {
                    int g = 0;
                    while (g < 9) {
                        boolean CellInSubset = false;
                        int a = 0;
                        while (a < size) {
                            if (counter[a] == g) {
                                CellInSubset = true;
                            }
                            ++a;
                        }
                        if (!CellInSubset) {
                            int y2 = 0;
                            while (y2 < 9) {
                                if (ValueUsed[y2] && MasterPossibilities[row][g][y2]) {
                                    Hint.HintCells[row][g] = true;
                                    if (level < 3) {
                                        int a2 = 0;
                                        while (a2 < size) {
                                            Hint.HintCells[row][counter[a2]] = true;
                                            ++a2;
                                        }
                                    }
                                    HintRow = row;
                                    HintColumn = g;
                                    HintValue = 0;
                                    HintScribble = y2;
                                    HintScribbleChange = true;
                                    HintCategory = 7 + size;
                                    Hint.MasterPossibilities[row][g][y2] = false;
                                    return true;
                                }
                                ++y2;
                            }
                        }
                        ++g;
                    }
                }
                counter = Hint.GetNextCounter(counter, size);
            }
            ++row;
        }
        return false;
    }

    private static boolean MasterNakedSubsetInColumn(int size, int level) {
        boolean[] ValueUsed = new boolean[9];
        boolean CounterOkay = false;
        boolean CounterOkay2 = true;
        int[] counter = new int[size];
        int usedcount = 0;
        int col = 0;
        while (col < 9) {
            int n = -1;
            int z = size - 1;
            while (z >= 0) {
                counter[++n] = z--;
            }
            while (counter[0] != 9 && CounterOkay2) {
                CounterOkay = false;
                while (!CounterOkay && counter[0] != 9) {
                    CounterOkay = true;
                    int t = 0;
                    while (t < size) {
                        if (Hint.MasterCellPossibilities(counter[t], col) == 0) {
                            CounterOkay = false;
                        }
                        ++t;
                    }
                    if (CounterOkay) continue;
                    Hint.GetNextCounter(counter, size);
                }
                if (counter[0] == 9) continue;
                int y = 0;
                while (y < 9) {
                    ValueUsed[y] = false;
                    ++y;
                }
                int x = 0;
                while (x < size) {
                    int w = 0;
                    while (w < 9) {
                        if (MasterPossibilities[counter[x]][col][w]) {
                            ValueUsed[w] = true;
                        }
                        ++w;
                    }
                    ++x;
                }
                usedcount = 0;
                y = 0;
                while (y < 9) {
                    if (ValueUsed[y]) {
                        ++usedcount;
                    }
                    ++y;
                }
                if (usedcount == size) {
                    int g = 0;
                    while (g < 9) {
                        boolean CellInSubset = false;
                        int a = 0;
                        while (a < size) {
                            if (counter[a] == g) {
                                CellInSubset = true;
                            }
                            ++a;
                        }
                        if (!CellInSubset) {
                            int y2 = 0;
                            while (y2 < 9) {
                                if (ValueUsed[y2] && MasterPossibilities[g][col][y2]) {
                                    Hint.HintCells[g][col] = true;
                                    if (level < 3) {
                                        int a2 = 0;
                                        while (a2 < size) {
                                            Hint.HintCells[counter[a2]][col] = true;
                                            ++a2;
                                        }
                                    }
                                    HintRow = g;
                                    HintColumn = col;
                                    HintValue = 0;
                                    HintScribble = y2;
                                    HintScribbleChange = true;
                                    HintCategory = 7 + size;
                                    Hint.MasterPossibilities[g][col][y2] = false;
                                    return true;
                                }
                                ++y2;
                            }
                        }
                        ++g;
                    }
                }
                counter = Hint.GetNextCounter(counter, size);
            }
            ++col;
        }
        return false;
    }

    private static boolean MasterNakedSubsetInBlock(int size, int level) {
        boolean[] ValueUsed = new boolean[9];
        boolean CounterOkay = false;
        boolean CounterOkay2 = true;
        int[] counter = new int[size];
        int usedcount = 0;
        int s = 0;
        while (s < 3) {
            int r = 3 * s;
            int u = 0;
            while (u < 3) {
                int v = 3 * u;
                int n = -1;
                int z = size - 1;
                while (z >= 0) {
                    counter[++n] = z--;
                }
                while (counter[0] != 9 && CounterOkay2) {
                    CounterOkay = false;
                    while (!CounterOkay && counter[0] != 9) {
                        CounterOkay = true;
                        int t = 0;
                        while (t < size) {
                            if (Hint.MasterCellPossibilities(r + counter[t] / 3, v + counter[t] % 3) == 0) {
                                CounterOkay = false;
                            }
                            ++t;
                        }
                        if (CounterOkay) continue;
                        Hint.GetNextCounter(counter, size);
                    }
                    if (counter[0] == 9) continue;
                    int y = 0;
                    while (y < 9) {
                        ValueUsed[y] = false;
                        ++y;
                    }
                    int x = 0;
                    while (x < size) {
                        int w = 0;
                        while (w < 9) {
                            if (MasterPossibilities[r + counter[x] / 3][v + counter[x] % 3][w]) {
                                ValueUsed[w] = true;
                            }
                            ++w;
                        }
                        ++x;
                    }
                    usedcount = 0;
                    y = 0;
                    while (y < 9) {
                        if (ValueUsed[y]) {
                            ++usedcount;
                        }
                        ++y;
                    }
                    if (usedcount == size) {
                        int g = 0;
                        while (g < 3) {
                            int h = 0;
                            while (h < 3) {
                                boolean CellInSubset = false;
                                int a = 0;
                                while (a < size) {
                                    if (counter[a] == 3 * g + h) {
                                        CellInSubset = true;
                                    }
                                    ++a;
                                }
                                if (!CellInSubset) {
                                    int y2 = 0;
                                    while (y2 < 9) {
                                        if (ValueUsed[y2] && MasterPossibilities[r + g][v + h][y2]) {
                                            Hint.HintCells[r + g][v + h] = true;
                                            if (level < 3) {
                                                int a2 = 0;
                                                while (a2 < size) {
                                                    Hint.HintCells[r + counter[a2] / 3][v + counter[a2] % 3] = true;
                                                    ++a2;
                                                }
                                            }
                                            HintRow = r + g;
                                            HintColumn = v + h;
                                            HintValue = 0;
                                            HintScribble = y2;
                                            HintScribbleChange = true;
                                            HintCategory = 7 + size;
                                            Hint.MasterPossibilities[r + g][v + h][y2] = false;
                                            return true;
                                        }
                                        ++y2;
                                    }
                                }
                                ++h;
                            }
                            ++g;
                        }
                    }
                    counter = Hint.GetNextCounter(counter, size);
                }
                ++u;
            }
            ++s;
        }
        return false;
    }

    private static boolean MasterHiddenSubset(int size) {
        return false;
    }

    private static void SetHintDifficulty(int diff) {
        if (diff > HintDifficulty) {
            HintDifficulty = diff;
        }
    }

    private static PuzzleDifficulty GetHintDifficulty() {
        switch (HintDifficulty) {
            case 1: {
                return PuzzleDifficulty.EASY;
            }
            case 2: {
                return PuzzleDifficulty.MILD;
            }
            case 3: {
                return PuzzleDifficulty.TRICKY;
            }
            case 4: {
                return PuzzleDifficulty.DIFFICULT;
            }
            case 5: {
                return PuzzleDifficulty.INSANE;
            }
        }
        return PuzzleDifficulty.NOT_RATED;
    }

    private static String HintMessage(int hint, int level) {
        switch (hint) {
            case 0: {
                switch (level) {
                    case 1: {
                        return ErrorCount == 1 ? "You have 1 error in your solution" : "You have " + ErrorCount + " errors in your solution";
                    }
                    case 2: {
                        return "Amend the marked cell";
                    }
                }
                return "The marked cell was an error";
            }
            case 1: {
                switch (level) {
                    case 1: {
                        return "Try checking for naked singles";
                    }
                    case 2: {
                        return "Look for a naked single in the marked cell";
                    }
                }
                return "The marked cell was a naked single";
            }
            case 2: {
                switch (level) {
                    case 1: {
                        return "Try checking for hidden singles";
                    }
                    case 2: {
                        return "Look for a hidden single in the marked cell";
                    }
                }
                return "The marked cell was a hidden single";
            }
            case 3: {
                switch (level) {
                    case 1: {
                        return "Try using the XYWing solving strategy";
                    }
                    case 2: {
                        return "Apply the XYWing strategy to the marked cells";
                    }
                }
                return "The marked cell had a scribble eliminated using the XYWing strategy";
            }
            case 4: {
                switch (level) {
                    case 1: {
                        return "Try using the XWing solving strategy";
                    }
                    case 2: {
                        return "Apply the XWing strategy to the marked cells";
                    }
                }
                return "The marked cell had a scribble eliminated using the XWing strategy";
            }
            case 5: {
                switch (level) {
                    case 1: {
                        return "Try checking your scribbles";
                    }
                    case 2: {
                        return "Check your scribbles in the marked cell";
                    }
                }
                return "The marked cell had an incorrect scribble";
            }
            case 6: {
                switch (level) {
                    case 1: {
                        return "Try applying the Block-Row/Column technique";
                    }
                    case 2: {
                        return "Apply the Block-Row/Column technique to the marked cells";
                    }
                }
                return "The marked cell had a scribble eliminated using the Block-Row/Column technique";
            }
            case 7: {
                switch (level) {
                    case 1: {
                        return "Try using scribbles in more cells";
                    }
                    case 2: {
                        return "The marked cell has had some scribbles entered - Try adding scribbles to all cells";
                    }
                }
                return "Try using the new scribbles";
            }
            case 8: {
                switch (level) {
                    case 1: {
                        return "Try applying the Block-Block technique";
                    }
                    case 2: {
                        return "Apply the Block-Block technique to the marked cells";
                    }
                }
                return "The marked cell had a scribble eliminated using the Block-Block technique";
            }
            case 9: {
                switch (level) {
                    case 1: {
                        return "Try checking for a naked pair";
                    }
                    case 2: {
                        return "Try using the marked naked pair to eliminate a scribble in the marked cell";
                    }
                }
                return "The marked cell had a scribble eliminated using a naked pair";
            }
            case 10: {
                switch (level) {
                    case 1: {
                        return "Try checking for a naked triple";
                    }
                    case 2: {
                        return "Try using the marked naked triple to eliminate a scribble in the marked cell";
                    }
                }
                return "The marked cell had a scribble eliminated using a naked triple";
            }
            case 11: {
                switch (level) {
                    case 1: {
                        return "Try checking for a naked quad";
                    }
                    case 2: {
                        return "Try using the marked naked quad to eliminate a scribble in the marked cell";
                    }
                }
                return "The marked cell had a scribble eliminated using a naked quad";
            }
            case 12: {
                switch (level) {
                    case 1: {
                        return "Try checking for a naked subset of size 5";
                    }
                    case 2: {
                        return "Try using the marked naked subset of size 5 to eliminate a scribble in the marked cell";
                    }
                }
                return "The marked cell had a scribble eliminated using a naked subset of size 5";
            }
            case 13: {
                switch (level) {
                    case 1: {
                        return "Try checking for a naked subset of size 6";
                    }
                    case 2: {
                        return "Try using the marked naked subset of size 6 to eliminate a scribble in the marked cell";
                    }
                }
                return "The marked cell had a scribble eliminated using a naked subset of size 6";
            }
            case 14: {
                switch (level) {
                    case 1: {
                        return "Try checking for a naked subset of size 7";
                    }
                    case 2: {
                        return "Try using the marked naked subset of size 7 to eliminate a scribble in the marked cell";
                    }
                }
                return "The marked cell had a scribble eliminated using a naked subset of size 7";
            }
            case 15: {
                switch (level) {
                    case 1: {
                        return "Try checking for a naked subset of size 8";
                    }
                    case 2: {
                        return "Try using the marked naked subset of size 8 to eliminate a scribble in the marked cell";
                    }
                }
                return "The marked cell had a scribble eliminated using a naked subset of size 8";
            }
            case 21: {
                switch (level) {
                    case 1: {
                        return "Try applying the Forcing Chains technique";
                    }
                    case 2: {
                        return "Apply the Forcing Chains technique to the marked cells";
                    }
                }
                return "The marked cell could be deduced using Forcing Chains";
            }
            case 22: {
                switch (level) {
                    case 1: {
                        return "Try applying the Conflicting Forcing Chains technique";
                    }
                    case 2: {
                        return "Apply the Conflicting Forcing Chains technique to the marked cells";
                    }
                }
                return "The marked cell had a scribble eliminated using the Conflicting Forcing Chains technique";
            }
            case 23: {
                switch (level) {
                    case 1: {
                        return "Try applying the Colouring technique";
                    }
                    case 2: {
                        return "Apply the Colouring technique to the marked cells";
                    }
                }
                return "The marked cell could be deduced using the Colouring technique";
            }
            case 24: {
                switch (level) {
                    case 1: {
                        return "Try applying the Colouring technique";
                    }
                    case 2: {
                        return "A scribble can be eliminated by applying the Colouring technique to the marked cells";
                    }
                }
                return "The marked cell had a scribble eliminated using the Colouring technique";
            }
            case 99: {
                switch (level) {
                    case 1: {
                        return "The hint system can help you no more - click again if you wish for it to reveal a cell";
                    }
                    case 2: {
                        return "The marked cell will be revealed if you click hint again";
                    }
                }
                return "The marked cell was revealed at your request";
            }
        }
        return "The next move is too advanced for the hint system - sorry!";
    }

    public static PuzzleDifficulty rateDifficulty(Puzzle p) {
        System.out.println("HINT - Rating Difficulty");
        q = p.clone();
        Hint.setPossibilities(q);
        MasterPossibilities = possibilities;
        RemainingCells = Hint.CellsRemaining(q);
        HintDifficulty = 0;
        while (RemainingCells > 0 && Hint.TrimMasterPossibilities(1) && HintDifficulty < 5) {
            if (HintValue == 0) continue;
            q.getCell(HintRow, HintColumn).setValue((byte)HintValue);
            Hint.setPossibilities(q);
            MasterPossibilities = possibilities;
            --RemainingCells;
        }
        System.out.println("HINT - Rated Difficulty (0-5): " + HintDifficulty);
        return Hint.GetHintDifficulty();
    }

    private static Boolean FoundHint() {
        if (Hint.NakedSingle(q).booleanValue()) {
            if (q.getDifficulty() == PuzzleDifficulty.NOT_RATED) {
                q.setDifficulty(PuzzleDifficulty.EASY);
            }
            return true;
        }
        if (Hint.HiddenSingle(q).booleanValue()) {
            if (q.getDifficulty() == PuzzleDifficulty.EASY || q.getDifficulty() == PuzzleDifficulty.NOT_RATED) {
                q.setDifficulty(PuzzleDifficulty.MILD);
            }
            return true;
        }
        q.setDifficulty(PuzzleDifficulty.TRICKY);
        return false;
    }

    public static boolean ErrorExists(Puzzle p) {
        System.out.println("method errorExists called");
        q = p.clone();
        q.resetGrid();
        q = Generator.solve(q);
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                if (p.getCell(a, b).getValue() != 0 && q.getCell(a, b).getValue() != p.getCell(a, b).getValue()) {
                    return true;
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static void CountErrors(Puzzle p) {
        ErrorCount = 0;
        q = p.clone();
        q.resetGrid();
        q = Generator.solve(q);
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                if (p.getCell(a, b).getValue() != 0 && q.getCell(a, b).getValue() != p.getCell(a, b).getValue() && ++ErrorCount == 1) {
                    Hint.HintCells[a][b] = true;
                    HintRow = a;
                    HintColumn = b;
                    HintValue = 0;
                }
                ++b;
            }
            ++a;
        }
    }

    private static void ClearHintCells(Puzzle p) {
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                Hint.HintCells[a][b] = false;
                p.getCell(a, b).setHintSelected(false);
                ++b;
            }
            ++a;
        }
    }

    private static void SetHintCells(Puzzle p) {
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                if (HintCells[a][b].booleanValue()) {
                    p.getCell(a, b).setHintSelected(true);
                }
                ++b;
            }
            ++a;
        }
    }

    private static Boolean NakedSingle(Puzzle p) {
        int value = 0;
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                if (p.getCell(a, b).getValue() == 0) {
                    int count = 0;
                    int c = 1;
                    while (c < 10) {
                        if (Hint.ValueInRow(p, a, c).booleanValue() || Hint.ValueInColumn(p, b, c).booleanValue() || Hint.ValueInBlock(p, a, b, c).booleanValue()) {
                            ++count;
                        } else {
                            value = c;
                        }
                        ++c;
                    }
                    if (count == 8) {
                        Hint.HintCells[a][b] = true;
                        HintRow = a;
                        HintColumn = b;
                        HintValue = value;
                        return true;
                    }
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static Boolean HiddenSingle(Puzzle p) {
        Boolean found = false;
        int a = 0;
        int b = 0;
        while (a < 9 && !found.booleanValue()) {
            found = Hint.CheckRowForHiddenSingle(p, a);
            ++a;
        }
        a = 0;
        while (a < 9 && !found.booleanValue()) {
            found = Hint.CheckColumnForHiddenSingle(p, a);
            ++a;
        }
        a = 0;
        while (a < 3 && b < 3 && !found.booleanValue()) {
            found = Hint.CheckBlockForHiddenSingle(p, a, b);
            if (++b != 3) continue;
            b = 0;
            ++a;
        }
        return found;
    }

    private static Boolean CheckRowForHiddenSingle(Puzzle p, int row) {
        int[] Possibilities = new int[10];
        int Column = 0;
        int Value = 0;
        Boolean found = false;
        int a = 1;
        while (a < 10) {
            int b = 0;
            while (b < 9) {
                if (!(p.getCell(row, b).getValue() != 0 || Hint.ValueInRow(p, row, a).booleanValue() || Hint.ValueInColumn(p, b, a).booleanValue() || Hint.ValueInBlock(p, row, b, a).booleanValue())) {
                    int n = a;
                    Possibilities[n] = Possibilities[n] + 1;
                }
                if (Possibilities[a] == 1 && Value == 0) {
                    Value = a;
                    Column = b;
                }
                if (Possibilities[a] > 1 && Value == a) {
                    Value = 0;
                }
                ++b;
            }
            ++a;
        }
        if (Value != 0) {
            found = true;
            Hint.HintCells[row][Column] = true;
            HintRow = row;
            HintColumn = Column;
            HintValue = Value;
        }
        return found;
    }

    private static Boolean CheckColumnForHiddenSingle(Puzzle p, int column) {
        int[] Possibilities = new int[10];
        int row = 0;
        int Value = 0;
        Boolean found = false;
        int a = 1;
        while (a < 10) {
            int b = 0;
            while (b < 9) {
                if (!(p.getCell(b, column).getValue() != 0 || Hint.ValueInRow(p, b, a).booleanValue() || Hint.ValueInColumn(p, column, a).booleanValue() || Hint.ValueInBlock(p, b, column, a).booleanValue())) {
                    int n = a;
                    Possibilities[n] = Possibilities[n] + 1;
                }
                if (Possibilities[a] == 1 && Value == 0) {
                    Value = a;
                    row = b;
                }
                if (Possibilities[a] > 1 && Value == a) {
                    Value = 0;
                }
                ++b;
            }
            ++a;
        }
        if (Value != 0) {
            found = true;
            Hint.HintCells[row][column] = true;
            HintRow = row;
            HintColumn = column;
            HintValue = Value;
        }
        return found;
    }

    private static Boolean CheckBlockForHiddenSingle(Puzzle p, int row, int column) {
        int[] Possibilities = new int[10];
        int Value = 0;
        int BlockRow = 0;
        int BlockColumn = 0;
        Boolean found = false;
        int a = 1;
        while (a < 10) {
            int b = row * 3;
            while (b < row * 3 + 3) {
                int c = column * 3;
                while (c < column * 3 + 3) {
                    if (!(p.getCell(b, c).getValue() != 0 || Hint.ValueInRow(p, b, a).booleanValue() || Hint.ValueInColumn(p, c, a).booleanValue() || Hint.ValueInBlock(p, b, c, a).booleanValue())) {
                        int n = a;
                        Possibilities[n] = Possibilities[n] + 1;
                    }
                    if (Possibilities[a] == 1 && Value == 0) {
                        Value = a;
                        BlockRow = b;
                        BlockColumn = c;
                    }
                    if (Possibilities[a] > 1 && Value == a) {
                        Value = 0;
                    }
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        if (Value != 0) {
            found = true;
            Hint.HintCells[BlockRow][BlockColumn] = true;
            HintRow = BlockRow;
            HintColumn = BlockColumn;
            HintValue = Value;
        }
        return found;
    }

    private static Boolean ValueInColumn(Puzzle p, int column, int value) {
        Boolean found = false;
        int a = 0;
        while (!found.booleanValue() && a < 9) {
            if (p.getCell(a, column).getValue() == (byte)value) {
                found = true;
            }
            ++a;
        }
        return found;
    }

    private static Boolean ValueInRow(Puzzle p, int row, int value) {
        Boolean found = false;
        int a = 0;
        while (!found.booleanValue() && a < 9) {
            if (p.getCell(row, a).getValue() == (byte)value) {
                found = true;
            }
            ++a;
        }
        return found;
    }

    private static Boolean ValueInBlock(Puzzle p, int row, int column, int value) {
        Boolean found = false;
        int a = 3 * (row / 3);
        int b = 3 * (column / 3);
        int i = a;
        while (i < a + 3) {
            int j = b;
            while (j < b + 3) {
                if (p.getCell(i, j).getValue() == (byte)value) {
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return found;
    }

    private static int CellsRemaining(Puzzle p) {
        int remaining = 81;
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                if (p.getCell(a, b).getValue() != 0) {
                    --remaining;
                }
                ++b;
            }
            ++a;
        }
        return remaining;
    }

    private static void RevealValue(Puzzle p, UIFrame uiframe) {
        q = p.clone();
        p.getCell(HintRow, HintColumn).setValue((byte)HintValue);
        System.out.println("HintValue: " + HintValue);
        if (HintScribbleChange) {
            p.getCell(HintRow, HintColumn).setScribble(HintScribble, false);
        }
        uiframe.changeMade(q);
    }

    private static boolean Error(Puzzle p) {
        if (!Hint.ErrorExists(p)) {
            return false;
        }
        Hint.CountErrors(p);
        return true;
    }

    private static boolean NakedPair(Puzzle p) {
        boolean returnvalue = false;
        int a = 0;
        while (a < 9) {
            if (Hint.NakedSubsetInRow(p, a, 2)) {
                returnvalue = true;
            }
            ++a;
        }
        a = 0;
        while (a < 9) {
            if (Hint.NakedSubsetInColumn(p, a, 2)) {
                returnvalue = true;
            }
            ++a;
        }
        a = 0;
        while (a < 3) {
            int b = 0;
            while (b < 3) {
                if (Hint.NakedSubsetInBlock(p, a, b, 2)) {
                    returnvalue = true;
                }
                ++b;
            }
            ++a;
        }
        return returnvalue;
    }

    private static boolean NakedPairInRow(Puzzle p, int row) {
        int b;
        int[][] Possibilities = new int[9][3];
        int a = 0;
        while (a < 9) {
            Possibilities[a][0] = 0;
            Possibilities[a][1] = 0;
            Possibilities[a][2] = 0;
            b = 1;
            while (b < 10) {
                if (!(p.getCell(row, a).getValue() != 0 || Hint.ValueInRow(p, row, b).booleanValue() || Hint.ValueInColumn(p, a, b).booleanValue() || Hint.ValueInBlock(p, row, a, b).booleanValue())) {
                    int[] nArray = Possibilities[a];
                    nArray[0] = nArray[0] + 1;
                    if (Possibilities[a][0] == 1) {
                        Possibilities[a][1] = b;
                    }
                    if (Possibilities[a][0] == 2) {
                        Possibilities[a][2] = b;
                    }
                }
                ++b;
            }
            ++a;
        }
        a = 1;
        while (a < 9) {
            b = 0;
            while (b < a) {
                if (Possibilities[a][0] == 2 && Possibilities[b][0] == 2 && Possibilities[a][1] == Possibilities[b][1] && Possibilities[a][2] == Possibilities[b][2]) {
                    p.getCell(row, a).setHintSelected(true);
                    p.getCell(row, b).setHintSelected(true);
                    return true;
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static boolean NakedPairInColumn(Puzzle p, int column) {
        int b;
        int[][] Possibilities = new int[9][3];
        int a = 0;
        while (a < 9) {
            Possibilities[a][0] = 0;
            Possibilities[a][1] = 0;
            Possibilities[a][2] = 0;
            b = 1;
            while (b < 10) {
                if (!(p.getCell(a, column).getValue() != 0 || Hint.ValueInRow(p, a, b).booleanValue() || Hint.ValueInColumn(p, column, b).booleanValue() || Hint.ValueInBlock(p, a, column, b).booleanValue())) {
                    int[] nArray = Possibilities[a];
                    nArray[0] = nArray[0] + 1;
                    if (Possibilities[a][0] == 1) {
                        Possibilities[a][1] = b;
                    }
                    if (Possibilities[a][0] == 2) {
                        Possibilities[a][2] = b;
                    }
                }
                ++b;
            }
            ++a;
        }
        a = 1;
        while (a < 9) {
            b = 0;
            while (b < a) {
                if (Possibilities[a][0] == 2 && Possibilities[b][0] == 2 && Possibilities[a][1] == Possibilities[b][1] && Possibilities[a][2] == Possibilities[b][2]) {
                    p.getCell(a, column).setHintSelected(true);
                    p.getCell(b, column).setHintSelected(true);
                    return true;
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static boolean NakedPairInBlock(Puzzle p, int row, int column) {
        int j;
        int a = 3 * row;
        int b = 3 * column;
        int n = -1;
        int[][] Possibilities = new int[9][3];
        int i = a;
        while (i < a + 3) {
            j = b;
            while (j < b + 3) {
                Possibilities[++n][0] = 0;
                Possibilities[n][1] = 0;
                Possibilities[n][2] = 0;
                int k = 1;
                while (k < 10) {
                    if (!(p.getCell(i, j).getValue() != 0 || Hint.ValueInRow(p, i, k).booleanValue() || Hint.ValueInColumn(p, j, k).booleanValue() || Hint.ValueInBlock(p, i, j, k).booleanValue())) {
                        int[] nArray = Possibilities[n];
                        nArray[0] = nArray[0] + 1;
                        if (Possibilities[n][0] == 1) {
                            Possibilities[n][1] = k;
                        }
                        if (Possibilities[n][0] == 2) {
                            Possibilities[n][2] = k;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < 9) {
            j = 0;
            while (j < i) {
                if (Possibilities[i][0] == 2 && Possibilities[j][0] == 2 && Possibilities[i][1] == Possibilities[j][1] && Possibilities[i][2] == Possibilities[j][2]) {
                    p.getCell(a + i / 3, b + i % 3).setHintSelected(true);
                    p.getCell(a + j / 3, b + j % 3).setHintSelected(true);
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static boolean NakedSubsetInRow(Puzzle p, int row, int size) {
        boolean[] used = new boolean[9];
        boolean returnvalue = false;
        boolean CounterOkay = false;
        boolean CounterOkay2 = true;
        int[][] Possibilities = new int[9][10];
        int[] counter = new int[size];
        int n = -1;
        int usedcount = 0;
        int a = 0;
        while (a < 9) {
            int z = 0;
            while (z <= 9) {
                Possibilities[a][z] = 0;
                ++z;
            }
            int b = 1;
            while (b < 10) {
                if (!(p.getCell(row, a).getValue() != 0 || Hint.ValueInRow(p, row, b).booleanValue() || Hint.ValueInColumn(p, a, b).booleanValue() || Hint.ValueInBlock(p, row, a, b).booleanValue())) {
                    int[] nArray = Possibilities[a];
                    nArray[0] = nArray[0] + 1;
                    Possibilities[a][Possibilities[a][0]] = b;
                }
                ++b;
            }
            ++a;
        }
        int z = size;
        while (z > 0) {
            counter[++n] = z--;
        }
        while (counter[0] != 10 && usedcount != size && CounterOkay2) {
            CounterOkay = false;
            while (!CounterOkay && counter[0] != 10) {
                CounterOkay = true;
                int t = 0;
                while (t < size) {
                    if (Possibilities[counter[t] - 1][0] == 0) {
                        CounterOkay = false;
                    }
                    ++t;
                }
                if (CounterOkay) continue;
                Hint.GetNextCounter(counter, size);
            }
            if (counter[0] == 10) continue;
            int y = 0;
            while (y < 9) {
                used[y] = false;
                ++y;
            }
            int x = 0;
            while (x < size) {
                int w = 1;
                while (w < 10) {
                    if (Possibilities[counter[x] - 1][w] != 0) {
                        used[Possibilities[counter[x] - 1][w] - 1] = true;
                    }
                    ++w;
                }
                ++x;
            }
            usedcount = 0;
            y = 0;
            while (y < 9) {
                if (used[y]) {
                    ++usedcount;
                }
                ++y;
            }
            if (usedcount == size) {
                returnvalue = true;
                continue;
            }
            counter = Hint.GetNextCounter(counter, size);
        }
        if (returnvalue) {
            a = 0;
            while (a < size) {
                p.getCell(row, counter[a] - 1).setHintSelected(true);
                ++a;
            }
        }
        return returnvalue;
    }

    private static boolean NakedSubsetInColumn(Puzzle p, int column, int size) {
        boolean[] used = new boolean[9];
        boolean returnvalue = false;
        boolean CounterOkay = false;
        boolean CounterOkay2 = true;
        int[][] Possibilities = new int[9][10];
        int[] counter = new int[size];
        int n = -1;
        int usedcount = 0;
        int a = 0;
        while (a < 9) {
            int z = 0;
            while (z <= 9) {
                Possibilities[a][z] = 0;
                ++z;
            }
            int b = 1;
            while (b < 10) {
                if (!(p.getCell(a, column).getValue() != 0 || Hint.ValueInRow(p, a, b).booleanValue() || Hint.ValueInColumn(p, column, b).booleanValue() || Hint.ValueInBlock(p, a, column, b).booleanValue())) {
                    int[] nArray = Possibilities[a];
                    nArray[0] = nArray[0] + 1;
                    Possibilities[a][Possibilities[a][0]] = b;
                }
                ++b;
            }
            ++a;
        }
        int z = size;
        while (z > 0) {
            counter[++n] = z--;
        }
        while (counter[0] != 10 && usedcount != size && CounterOkay2) {
            CounterOkay = false;
            while (!CounterOkay && counter[0] != 10) {
                CounterOkay = true;
                int t = 0;
                while (t < size) {
                    if (Possibilities[counter[t] - 1][0] == 0) {
                        CounterOkay = false;
                    }
                    ++t;
                }
                if (CounterOkay) continue;
                Hint.GetNextCounter(counter, size);
            }
            if (counter[0] == 10) continue;
            int y = 0;
            while (y < 9) {
                used[y] = false;
                ++y;
            }
            int x = 0;
            while (x < size) {
                int w = 1;
                while (w < 10) {
                    if (Possibilities[counter[x] - 1][w] != 0) {
                        used[Possibilities[counter[x] - 1][w] - 1] = true;
                    }
                    ++w;
                }
                ++x;
            }
            usedcount = 0;
            y = 0;
            while (y < 9) {
                if (used[y]) {
                    ++usedcount;
                }
                ++y;
            }
            if (usedcount == size) {
                returnvalue = true;
                continue;
            }
            counter = Hint.GetNextCounter(counter, size);
        }
        if (returnvalue) {
            a = 0;
            while (a < size) {
                p.getCell(counter[a] - 1, column).setHintSelected(true);
                ++a;
            }
        }
        return returnvalue;
    }

    private static boolean NakedSubsetInBlock(Puzzle p, int BlockRow, int BlockColumn, int size) {
        boolean[] used = new boolean[9];
        boolean returnvalue = false;
        boolean CounterOkay = false;
        boolean CounterOkay2 = true;
        int[][] Possibilities = new int[9][10];
        int[] counter = new int[size];
        int a = -1;
        int n = -1;
        int usedcount = 0;
        int row = 3 * BlockRow;
        int column = 3 * BlockColumn;
        int s = row;
        while (s < row + 3) {
            int t = column;
            while (t < column + 3) {
                ++a;
                int z = 0;
                while (z <= 9) {
                    Possibilities[a][z] = 0;
                    ++z;
                }
                int b = 1;
                while (b < 10) {
                    if (!(p.getCell(s, t).getValue() != 0 || Hint.ValueInRow(p, s, b).booleanValue() || Hint.ValueInColumn(p, t, b).booleanValue() || Hint.ValueInBlock(p, s, t, b).booleanValue())) {
                        int[] nArray = Possibilities[a];
                        nArray[0] = nArray[0] + 1;
                        Possibilities[a][Possibilities[a][0]] = b;
                    }
                    ++b;
                }
                ++t;
            }
            ++s;
        }
        int z = size;
        while (z > 0) {
            counter[++n] = z--;
        }
        while (counter[0] != 10 && usedcount != size && CounterOkay2) {
            CounterOkay = false;
            while (!CounterOkay && counter[0] != 10) {
                CounterOkay = true;
                int v = 0;
                while (v < size) {
                    if (Possibilities[counter[v] - 1][0] == 0) {
                        CounterOkay = false;
                    }
                    ++v;
                }
                if (CounterOkay) continue;
                Hint.GetNextCounter(counter, size);
            }
            if (counter[0] == 10) continue;
            int y = 0;
            while (y < 9) {
                used[y] = false;
                ++y;
            }
            int x = 0;
            while (x < size) {
                int w = 1;
                while (w < 10) {
                    if (Possibilities[counter[x] - 1][w] != 0) {
                        used[Possibilities[counter[x] - 1][w] - 1] = true;
                    }
                    ++w;
                }
                ++x;
            }
            usedcount = 0;
            y = 0;
            while (y < 9) {
                if (used[y]) {
                    ++usedcount;
                }
                ++y;
            }
            if (usedcount == size) {
                returnvalue = true;
                continue;
            }
            counter = Hint.GetNextCounter(counter, size);
        }
        if (returnvalue) {
            int u = 0;
            while (u < size) {
                p.getCell(row + (counter[u] - 1) / 3, column + (counter[u] - 1) % 3).setHintSelected(true);
                ++u;
            }
        }
        return returnvalue;
    }

    private static int[] GetNextCounter(int[] counter, int size) {
        int n = size - 1;
        while (n > 0 && counter[n] + 1 == counter[n - 1]) {
            --n;
        }
        int n2 = n;
        counter[n2] = counter[n2] + 1;
        if (n != size - 1) {
            int a = n + 1;
            while (a < size) {
                counter[a] = size - a - 1;
                ++a;
            }
        }
        return counter;
    }

    private static boolean XWing(int level) {
        int g;
        int count2;
        int d;
        int count1;
        int c;
        int b;
        int pos1_1 = -1;
        int pos2_1 = -1;
        int pos1_2 = -1;
        int pos2_2 = -1;
        int a = 0;
        while (a < 9) {
            b = 0;
            while (b < 9) {
                c = 0;
                count1 = 0;
                while (c < 9 && count1 < 3) {
                    if (MasterPossibilities[a][c][b]) {
                        if (++count1 == 1) {
                            pos1_1 = c;
                        }
                        if (count1 == 2) {
                            pos2_1 = c;
                        }
                    }
                    ++c;
                }
                if (count1 == 2) {
                    d = a + 1;
                    while (d < 9) {
                        c = 0;
                        count2 = 0;
                        while (c < 9 && count2 < 3) {
                            if (MasterPossibilities[d][c][b]) {
                                if (++count2 == 1) {
                                    pos1_2 = c;
                                }
                                if (count2 == 2) {
                                    pos2_2 = c;
                                }
                            }
                            ++c;
                        }
                        if (count2 == 2 && pos1_1 == pos1_2 && pos2_1 == pos2_2) {
                            g = 0;
                            while (g < 9) {
                                if (g != a && g != d) {
                                    if (MasterPossibilities[g][pos1_1][b]) {
                                        if (level == 2) {
                                            Hint.HintCells[a][pos1_1] = true;
                                            Hint.HintCells[d][pos1_2] = true;
                                            Hint.HintCells[a][pos2_1] = true;
                                            Hint.HintCells[d][pos2_2] = true;
                                        }
                                        Hint.HintCells[g][pos1_1] = true;
                                        HintRow = g;
                                        HintColumn = pos1_1;
                                        HintScribble = b;
                                        HintScribbleChange = true;
                                        HintValue = 0;
                                        HintCategory = 4;
                                        Hint.MasterPossibilities[g][pos1_1][b] = false;
                                        return true;
                                    }
                                    if (MasterPossibilities[g][pos2_1][b]) {
                                        if (level == 2) {
                                            Hint.HintCells[a][pos1_1] = true;
                                            Hint.HintCells[d][pos1_2] = true;
                                            Hint.HintCells[a][pos2_1] = true;
                                            Hint.HintCells[d][pos2_2] = true;
                                        }
                                        Hint.HintCells[g][pos2_1] = true;
                                        HintRow = g;
                                        HintColumn = pos2_1;
                                        HintScribble = b;
                                        HintScribbleChange = true;
                                        HintValue = 0;
                                        HintCategory = 4;
                                        Hint.MasterPossibilities[g][pos2_1][b] = false;
                                        return true;
                                    }
                                }
                                ++g;
                            }
                        }
                        ++d;
                    }
                }
                ++b;
            }
            ++a;
        }
        a = 0;
        while (a < 9) {
            b = 0;
            while (b < 9) {
                c = 0;
                count1 = 0;
                while (c < 9 && count1 < 3) {
                    if (MasterPossibilities[c][a][b]) {
                        if (++count1 == 1) {
                            pos1_1 = c;
                        }
                        if (count1 == 2) {
                            pos2_1 = c;
                        }
                    }
                    ++c;
                }
                if (count1 == 2) {
                    d = a + 1;
                    while (d < 9) {
                        c = 0;
                        count2 = 0;
                        while (c < 9 && count2 < 3) {
                            if (MasterPossibilities[c][d][b]) {
                                if (++count2 == 1) {
                                    pos1_2 = c;
                                }
                                if (count2 == 2) {
                                    pos2_2 = c;
                                }
                            }
                            ++c;
                        }
                        if (count2 == 2 && pos1_1 == pos1_2 && pos2_1 == pos2_2) {
                            g = 0;
                            while (g < 9) {
                                if (g != a && g != d) {
                                    if (MasterPossibilities[pos1_1][g][b]) {
                                        if (level == 2) {
                                            Hint.HintCells[pos1_1][a] = true;
                                            Hint.HintCells[pos1_2][d] = true;
                                            Hint.HintCells[pos2_1][a] = true;
                                            Hint.HintCells[pos2_2][d] = true;
                                        }
                                        Hint.HintCells[pos1_1][g] = true;
                                        HintRow = pos1_1;
                                        HintColumn = g;
                                        HintScribble = b;
                                        HintScribbleChange = true;
                                        HintValue = 0;
                                        HintCategory = 4;
                                        Hint.MasterPossibilities[pos1_1][g][b] = false;
                                        return true;
                                    }
                                    if (MasterPossibilities[pos2_1][g][b]) {
                                        if (level == 2) {
                                            Hint.HintCells[pos1_1][a] = true;
                                            Hint.HintCells[pos1_2][d] = true;
                                            Hint.HintCells[pos2_1][a] = true;
                                            Hint.HintCells[pos2_2][d] = true;
                                        }
                                        Hint.HintCells[pos2_1][g] = true;
                                        HintRow = pos2_1;
                                        HintColumn = g;
                                        HintScribble = b;
                                        HintScribbleChange = true;
                                        HintCategory = 4;
                                        HintValue = 0;
                                        Hint.MasterPossibilities[pos2_1][g][b] = false;
                                        return true;
                                    }
                                }
                                ++g;
                            }
                        }
                        ++d;
                    }
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static void setPossibilities(Puzzle p) {
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                int c = 1;
                while (c < 10) {
                    Hint.possibilities[a][b][c - 1] = p.getCell(a, b).getValue() == 0 && Hint.ValueInRow(p, a, c) == false && Hint.ValueInColumn(p, b, c) == false && Hint.ValueInBlock(p, a, b, c) == false;
                    ++c;
                }
                ++b;
            }
            ++a;
        }
    }

    private static Boolean ScribbleErrors(Puzzle p) {
        Hint.setPossibilities(p);
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                if (p.getCell(a, b).getValue() == 0) {
                    int c = 0;
                    while (c < 9) {
                        if (p.getCell(a, b).getScribble(c) && !possibilities[a][b][c]) {
                            Hint.HintCells[a][b] = true;
                            HintRow = a;
                            HintColumn = b;
                            HintScribble = c;
                            HintScribbleChange = true;
                            HintValue = 0;
                            return true;
                        }
                        ++c;
                    }
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    public static void ShowMostBasicScribbles(Puzzle p, UIFrame uiframe) {
        q = p.clone();
        Hint.setPossibilities(p);
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                int c = 0;
                while (c < 9) {
                    if (possibilities[a][b][c]) {
                        p.getCell(a, b).setScribble(c, true);
                    } else {
                        p.getCell(a, b).setScribble(c, false);
                    }
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        uiframe.changeMade(q);
    }

    private static boolean NotUsingScribbles(Puzzle p, int level, UIFrame uiframe) {
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                if (p.getCell(a, b).getValue() == 0) {
                    boolean scribble = false;
                    int c = 0;
                    while (c < 9) {
                        if (p.getCell(a, b).getScribble(c)) {
                            scribble = true;
                        }
                        ++c;
                    }
                    if (!scribble) {
                        if (level == 2) {
                            Hint.setPossibilities(p);
                            int d = 0;
                            while (d < 9) {
                                if (possibilities[a][b][d]) {
                                    p.getCell(a, b).setScribble(d, true);
                                }
                                ++d;
                            }
                            HintValue = 0;
                            HintRow = a;
                            HintColumn = b;
                            p.getCell(a, b).setHintSelected(true);
                        }
                        if (level == 3) {
                            Hint.ShowMostBasicScribbles(p, uiframe);
                        }
                        return true;
                    }
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static boolean XYWing(int level) {
        int a = 0;
        while (a < 9) {
            int b = 0;
            while (b < 9) {
                int CellOptionCount = 0;
                int x = -1;
                int y = -1;
                int c = 0;
                while (c < 9) {
                    if (MasterPossibilities[a][b][c]) {
                        ++CellOptionCount;
                        if (x == -1) {
                            x = c;
                        }
                        if (y == -1 && x != c) {
                            y = c;
                        }
                    }
                    ++c;
                }
                if (CellOptionCount == 2) {
                    int j;
                    int i;
                    int h;
                    int g;
                    int f;
                    int z;
                    int e;
                    int v;
                    int w;
                    int d = 0;
                    while (d < 9) {
                        if (d != b) {
                            CellOptionCount = 0;
                            w = -1;
                            v = -1;
                            e = 0;
                            while (e < 9) {
                                if (MasterPossibilities[a][d][e]) {
                                    ++CellOptionCount;
                                    if (w == -1) {
                                        w = e;
                                    }
                                    if (v == -1 && w != e) {
                                        v = e;
                                    }
                                }
                                ++e;
                            }
                            if (CellOptionCount == 2 && (w == x || v == x)) {
                                z = w == x ? v : w;
                                f = 3 * (a / 3);
                                while (f < 3 + 3 * (a / 3)) {
                                    g = 3 * (b / 3);
                                    while (g < 3 + 3 * (b / 3)) {
                                        if (f != a) {
                                            w = -1;
                                            v = -1;
                                            CellOptionCount = 0;
                                            h = 0;
                                            while (h < 9) {
                                                if (MasterPossibilities[f][g][h]) {
                                                    ++CellOptionCount;
                                                    if (w == -1) {
                                                        w = h;
                                                    }
                                                    if (v == -1 && w != h) {
                                                        v = h;
                                                    }
                                                }
                                                ++h;
                                            }
                                            if (!(CellOptionCount != 2 || v != y && v != z || w != y && w != z)) {
                                                System.out.println("FOUND AN XYWING");
                                                i = 3 * (d / 3);
                                                while (i < 3 + 3 * (d / 3)) {
                                                    if (MasterPossibilities[f][i][z]) {
                                                        if (level < 3) {
                                                            Hint.HintCells[a][b] = true;
                                                            Hint.HintCells[a][d] = true;
                                                            Hint.HintCells[f][g] = true;
                                                        }
                                                        Hint.HintCells[f][i] = true;
                                                        HintValue = 0;
                                                        HintRow = f;
                                                        HintColumn = i;
                                                        HintScribble = z;
                                                        HintScribbleChange = true;
                                                        HintCategory = 3;
                                                        Hint.MasterPossibilities[f][i][z] = false;
                                                        System.out.println("XYWING 1");
                                                        return true;
                                                    }
                                                    ++i;
                                                }
                                                j = 3 * (b / 3);
                                                while (j < 3 + 3 * (b / 3)) {
                                                    if (j != b && MasterPossibilities[f][j][z]) {
                                                        if (level < 3) {
                                                            Hint.HintCells[a][b] = true;
                                                            Hint.HintCells[a][d] = true;
                                                            Hint.HintCells[f][g] = true;
                                                        }
                                                        Hint.HintCells[f][j] = true;
                                                        HintValue = 0;
                                                        HintRow = f;
                                                        HintColumn = j;
                                                        HintScribble = z;
                                                        HintScribbleChange = true;
                                                        HintCategory = 3;
                                                        Hint.MasterPossibilities[f][j][z] = false;
                                                        System.out.println("XYWING 2");
                                                        return true;
                                                    }
                                                    ++j;
                                                }
                                            }
                                        }
                                        ++g;
                                    }
                                    ++f;
                                }
                                f = 3 * (a / 3);
                                while (f < 3 + 3 * (a / 3)) {
                                    g = 3 * (d / 3);
                                    while (g < 3 + 3 * (d / 3)) {
                                        if (f != a) {
                                            w = -1;
                                            v = -1;
                                            CellOptionCount = 0;
                                            h = 0;
                                            while (h < 9) {
                                                if (MasterPossibilities[f][g][h]) {
                                                    ++CellOptionCount;
                                                    if (w == -1) {
                                                        w = h;
                                                    }
                                                    if (v == -1 && w != h) {
                                                        v = h;
                                                    }
                                                }
                                                ++h;
                                            }
                                            if (!(CellOptionCount != 2 || v != y && v != z || w != y && w != z)) {
                                                i = 3 * (b / 3);
                                                while (i < 3 + 3 * (b / 3)) {
                                                    if (MasterPossibilities[f][i][z]) {
                                                        if (level < 3) {
                                                            Hint.HintCells[a][b] = true;
                                                            Hint.HintCells[a][d] = true;
                                                            Hint.HintCells[f][g] = true;
                                                        }
                                                        Hint.HintCells[f][i] = true;
                                                        HintValue = 0;
                                                        HintRow = f;
                                                        HintColumn = i;
                                                        HintScribble = z;
                                                        HintScribbleChange = true;
                                                        HintCategory = 3;
                                                        Hint.MasterPossibilities[f][i][z] = false;
                                                        System.out.println("XYWING 3");
                                                        return true;
                                                    }
                                                    ++i;
                                                }
                                                j = 3 * (d / 3);
                                                while (j < 3 + 3 * (d / 3)) {
                                                    if (j != d && MasterPossibilities[f][j][z]) {
                                                        if (level < 3) {
                                                            Hint.HintCells[a][b] = true;
                                                            Hint.HintCells[a][d] = true;
                                                            Hint.HintCells[f][g] = true;
                                                        }
                                                        Hint.HintCells[f][j] = true;
                                                        HintValue = 0;
                                                        HintRow = f;
                                                        HintColumn = j;
                                                        HintScribble = z;
                                                        HintScribbleChange = true;
                                                        HintCategory = 3;
                                                        Hint.MasterPossibilities[f][j][z] = false;
                                                        System.out.println("XYWING 4");
                                                        return true;
                                                    }
                                                    ++j;
                                                }
                                            }
                                        }
                                        ++g;
                                    }
                                    ++f;
                                }
                                f = 0;
                                while (f < 9) {
                                    CellOptionCount = 0;
                                    w = -1;
                                    v = -1;
                                    g = 0;
                                    while (g < 9) {
                                        if (MasterPossibilities[f][b][g]) {
                                            ++CellOptionCount;
                                            if (w == -1) {
                                                w = g;
                                            }
                                            if (v == -1 && w != g) {
                                                v = g;
                                            }
                                        }
                                        ++g;
                                    }
                                    if (!(CellOptionCount != 2 || v != y && v != z || w != y && w != z || !MasterPossibilities[f][d][z])) {
                                        if (level < 3) {
                                            Hint.HintCells[a][b] = true;
                                            Hint.HintCells[a][d] = true;
                                            Hint.HintCells[f][b] = true;
                                        }
                                        Hint.HintCells[f][d] = true;
                                        HintRow = f;
                                        HintColumn = d;
                                        HintValue = 0;
                                        HintScribble = z;
                                        HintScribbleChange = true;
                                        HintCategory = 3;
                                        Hint.MasterPossibilities[f][d][z] = false;
                                        System.out.println("XYWING 5");
                                        return true;
                                    }
                                    ++f;
                                }
                                f = 0;
                                while (f < 9) {
                                    CellOptionCount = 0;
                                    w = -1;
                                    v = -1;
                                    g = 0;
                                    while (g < 9) {
                                        if (MasterPossibilities[f][d][g]) {
                                            ++CellOptionCount;
                                            if (w == -1) {
                                                w = g;
                                            }
                                            if (v == -1 && w != g) {
                                                v = g;
                                            }
                                        }
                                        ++g;
                                    }
                                    if (!(CellOptionCount != 2 || v != y && v != z || w != y && w != z || !MasterPossibilities[f][b][z])) {
                                        if (level < 3) {
                                            Hint.HintCells[a][b] = true;
                                            Hint.HintCells[a][d] = true;
                                            Hint.HintCells[f][d] = true;
                                        }
                                        Hint.HintCells[f][b] = true;
                                        HintRow = f;
                                        HintColumn = b;
                                        HintValue = 0;
                                        HintScribble = z;
                                        HintScribbleChange = true;
                                        HintCategory = 3;
                                        Hint.MasterPossibilities[f][b][z] = false;
                                        System.out.println("XYWING 6");
                                        return true;
                                    }
                                    ++f;
                                }
                            }
                        }
                        ++d;
                    }
                    d = 0;
                    while (d < 9) {
                        if (d != a) {
                            CellOptionCount = 0;
                            w = -1;
                            v = -1;
                            e = 0;
                            while (e < 9) {
                                if (MasterPossibilities[d][b][e]) {
                                    ++CellOptionCount;
                                    if (w == -1) {
                                        w = e;
                                    }
                                    if (v == -1 && w != e) {
                                        v = e;
                                    }
                                }
                                ++e;
                            }
                            if (CellOptionCount == 2 && (w == x || v == x)) {
                                z = w == x ? v : w;
                                f = 3 * (a / 3);
                                while (f < 3 + 3 * (a / 3)) {
                                    g = 3 * (b / 3);
                                    while (g < 3 + 3 * (b / 3)) {
                                        if (g != b) {
                                            w = -1;
                                            v = -1;
                                            CellOptionCount = 0;
                                            h = 0;
                                            while (h < 9) {
                                                if (MasterPossibilities[f][g][h]) {
                                                    ++CellOptionCount;
                                                    if (w == -1) {
                                                        w = h;
                                                    }
                                                    if (v == -1 && w != h) {
                                                        v = h;
                                                    }
                                                }
                                                ++h;
                                            }
                                            if (!(CellOptionCount != 2 || v != y && v != z || w != y && w != z)) {
                                                System.out.println("FOUND AN XYWING");
                                                i = 3 * (d / 3);
                                                while (i < 3 + 3 * (d / 3)) {
                                                    if (MasterPossibilities[i][g][z] && i != f) {
                                                        if (level < 3) {
                                                            Hint.HintCells[a][b] = true;
                                                            Hint.HintCells[d][b] = true;
                                                            Hint.HintCells[f][g] = true;
                                                        }
                                                        Hint.HintCells[i][g] = true;
                                                        HintValue = 0;
                                                        HintRow = i;
                                                        HintColumn = g;
                                                        HintScribble = z;
                                                        HintScribbleChange = true;
                                                        HintCategory = 3;
                                                        Hint.MasterPossibilities[i][g][z] = false;
                                                        System.out.println("XYWING 7");
                                                        return true;
                                                    }
                                                    ++i;
                                                }
                                                j = 3 * (a / 3);
                                                while (j < 3 + 3 * (a / 3)) {
                                                    if (j != a && MasterPossibilities[j][b][z] && j != a && j != d) {
                                                        if (level < 3) {
                                                            Hint.HintCells[a][b] = true;
                                                            Hint.HintCells[d][b] = true;
                                                            Hint.HintCells[f][g] = true;
                                                        }
                                                        Hint.HintCells[j][b] = true;
                                                        HintValue = 0;
                                                        HintRow = j;
                                                        HintColumn = b;
                                                        HintScribble = z;
                                                        HintScribbleChange = true;
                                                        HintCategory = 3;
                                                        Hint.MasterPossibilities[j][b][z] = false;
                                                        System.out.println("XYWING 8");
                                                        return true;
                                                    }
                                                    ++j;
                                                }
                                            }
                                        }
                                        ++g;
                                    }
                                    ++f;
                                }
                                f = 3 * (d / 3);
                                while (f < 3 + 3 * (d / 3)) {
                                    g = 3 * (b / 3);
                                    while (g < 3 + 3 * (b / 3)) {
                                        if (g != b) {
                                            w = -1;
                                            v = -1;
                                            CellOptionCount = 0;
                                            h = 0;
                                            while (h < 9) {
                                                if (MasterPossibilities[f][g][h]) {
                                                    ++CellOptionCount;
                                                    if (w == -1) {
                                                        w = h;
                                                    }
                                                    if (v == -1 && w != h) {
                                                        v = h;
                                                    }
                                                }
                                                ++h;
                                            }
                                            if (!(CellOptionCount != 2 || v != y && v != z || w != y && w != z)) {
                                                System.out.println("FOUND AN XYWING");
                                                i = 3 * (a / 3);
                                                while (i < 3 + 3 * (a / 3)) {
                                                    if (MasterPossibilities[i][g][z] && i != f) {
                                                        if (level < 3) {
                                                            Hint.HintCells[a][b] = true;
                                                            Hint.HintCells[d][b] = true;
                                                            Hint.HintCells[f][g] = true;
                                                        }
                                                        Hint.HintCells[i][g] = true;
                                                        HintValue = 0;
                                                        HintRow = i;
                                                        HintColumn = g;
                                                        HintScribble = z;
                                                        HintScribbleChange = true;
                                                        HintCategory = 3;
                                                        Hint.MasterPossibilities[i][g][z] = false;
                                                        System.out.println("XYWING 9");
                                                        return true;
                                                    }
                                                    ++i;
                                                }
                                                j = 3 * (d / 3);
                                                while (j < 3 + 3 * (d / 3)) {
                                                    if (j != d && MasterPossibilities[j][b][z]) {
                                                        if (level < 3) {
                                                            Hint.HintCells[a][b] = true;
                                                            Hint.HintCells[d][b] = true;
                                                            Hint.HintCells[f][g] = true;
                                                        }
                                                        Hint.HintCells[j][b] = true;
                                                        HintValue = 0;
                                                        HintRow = j;
                                                        HintColumn = b;
                                                        HintScribble = z;
                                                        HintScribbleChange = true;
                                                        HintCategory = 3;
                                                        Hint.MasterPossibilities[j][b][z] = false;
                                                        System.out.println("XYWING 10");
                                                        return true;
                                                    }
                                                    ++j;
                                                }
                                            }
                                        }
                                        ++g;
                                    }
                                    ++f;
                                }
                            }
                        }
                        ++d;
                    }
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    private static int MasterCellPossibilities(int row, int column) {
        int Count = 0;
        int a = 0;
        while (a < 9) {
            if (MasterPossibilities[row][column][a]) {
                ++Count;
            }
            ++a;
        }
        return Count;
    }

    private static void FinalResortHint(Puzzle p, int level) {
        int a = 0;
        block0: while (a < 9) {
            int b = 0;
            while (b < 9) {
                if (p.getCell(a, b).getValue() == 0) {
                    q = p.clone();
                    q = Generator.solve(q);
                    Hint.HintCells[a][b] = true;
                    HintRow = a;
                    HintColumn = b;
                    HintValue = q.getCell(a, b).getValue();
                    HintScribbleChange = false;
                    HintCategory = 99;
                    break block0;
                }
                ++b;
            }
            ++a;
        }
    }
}

