/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui.nav;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import sudoku.ui.UIFrame;
import sudoku.ui.nav.NavButtonTemplate;
import sudoku.ui.nav.NavTemplate;

public class NavSingle
extends NavTemplate
implements Runnable {
    private UIFrame uiFrame;
    private long puzzleTime;
    private int hintsUsed = 0;
    private Boolean undoActive;
    private Boolean redoActive;
    private Boolean timerDisplayState = true;
    private Thread timer;
    private Boolean timerOn = false;
    private NavButtonTemplate hint;
    private NavButtonTemplate undo;
    private NavButtonTemplate redo;
    private NavButtonTemplate pause;
    private NavButtonTemplate save;
    private NavButtonTemplate reset;
    private NavButtonTemplate generateNew;
    private NavButtonTemplate endGame;
    private Box b = new Box(0);
    private JLabel hintsUsedSoFar = new JLabel("0 Hints Used");
    private JLabel timeTakenTitle = new JLabel("Time Taken");
    private JLabel timeTaken = new JLabel("00:00:00");
    private JLabel pausedMessage = new JLabel("Game Paused!");

    public NavSingle(UIFrame uiFrame, String title) {
        super(title);
        this.uiFrame = uiFrame;
        this.hint = new NavButtonTemplate("Hint!");
        this.undo = new NavButtonTemplate("Undo");
        this.redo = new NavButtonTemplate("Redo");
        this.pause = new NavButtonTemplate("Pause Game");
        this.save = new NavButtonTemplate("Save Game");
        this.reset = new NavButtonTemplate("Reset Grid");
        this.generateNew = new NavButtonTemplate("Generate New");
        this.endGame = new NavButtonTemplate("End Game");
        this.timeTakenTitle.setAlignmentX(0.5f);
        this.timeTakenTitle.setFont(new Font("SansSerif", 0, 14));
        this.timeTaken.setAlignmentX(0.5f);
        this.timeTaken.setFont(new Font("SansSerif", 0, 16));
        this.hintsUsedSoFar.setAlignmentX(0.5f);
        this.hintsUsedSoFar.setFont(new Font("SansSerif", 0, 14));
        this.pausedMessage.setAlignmentX(0.5f);
        this.pausedMessage.setFont(new Font("SansSerif", 1, 16));
        Dimension d = new Dimension(77, 35);
        this.undo.setMinimumSize(d);
        this.redo.setMinimumSize(d);
        this.undo.setMaximumSize(d);
        this.redo.setMaximumSize(d);
        this.add(this.hint);
        this.add(this.vSpace());
        this.b.add(this.undo);
        this.b.add(Box.createHorizontalStrut(6));
        this.b.add(this.redo);
        this.b.setMinimumSize(new Dimension(160, 35));
        this.b.setMaximumSize(new Dimension(160, 35));
        this.add(this.b);
        this.add(this.vSpace());
        this.add(this.pause);
        this.add(this.vSpace());
        this.add(this.save);
        this.add(this.vSpace());
        this.add(this.reset);
        this.add(this.vSpace());
        this.add(this.generateNew);
        this.add(this.vSpace());
        this.add(this.endGame);
        this.add(this.vSpace(10));
        this.add(this.pausedMessage);
        this.add(this.timeTakenTitle);
        this.add(this.timeTaken);
        this.add(this.vSpace(10));
        this.add(this.hintsUsedSoFar);
        this.pausedMessage.setVisible(false);
        this.hint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Hint");
                NavSingle.this.hintButton();
            }
        });
        this.undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Undo");
                NavSingle.this.undoButton();
            }
        });
        this.redo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Redo");
                NavSingle.this.redoButton();
            }
        });
        this.pause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Pause");
                NavSingle.this.pauseButton();
            }
        });
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Save");
                NavSingle.this.saveButton();
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Reset");
                NavSingle.this.resetButton();
            }
        });
        this.generateNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Generate New");
                NavSingle.this.generateNewButton();
            }
        });
        this.endGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - End Game");
                NavSingle.this.endGameButton();
            }
        });
        this.timer = new Thread(this);
        this.timer.start();
    }

    public void hintButton() {
        this.uiFrame.hint();
    }

    public void undoButton() {
        this.uiFrame.undo();
    }

    public void redoButton() {
        this.uiFrame.redo();
    }

    public void pauseButton() {
        this.uiFrame.pauseGame();
    }

    public void saveButton() {
        this.uiFrame.saveGame();
    }

    public void generateNewButton() {
        if (this.uiFrame.getCustMode().booleanValue()) {
            this.uiFrame.editCustomPuzzle();
        } else {
            this.uiFrame.generatePuzzle();
            this.resetPanel();
        }
    }

    public void endGameButton() {
        this.uiFrame.endGame();
        this.uiFrame.setCustMode(false);
    }

    public void resetButton() {
        this.uiFrame.resetGrid();
    }

    public void undoEnable(Boolean on) {
        this.undoActive = on;
        this.undo.setEnabled(on);
    }

    public void redoEnable(Boolean on) {
        this.redoActive = on;
        this.redo.setEnabled(on);
    }

    public void pauseMode(Boolean on) {
        this.hint.setEnabled(on == false);
        if (this.undoActive.booleanValue()) {
            this.undo.setEnabled(on == false);
        }
        if (this.redoActive.booleanValue()) {
            this.redo.setEnabled(on == false);
        }
        this.reset.setEnabled(on == false);
        this.generateNew.setEnabled(on == false);
        this.hintsUsedSoFar.setVisible(on == false);
        this.pausedMessage.setVisible(on);
        if (this.timerDisplayState.booleanValue()) {
            this.timeTakenTitle.setVisible(on == false);
            this.timeTaken.setVisible(on == false);
        }
        if (on.booleanValue()) {
            this.pause.setText("Resume");
        } else {
            this.pause.setText("Pause");
        }
    }

    public String timeToString(long t) {
        long secs = t % 60L;
        long hours = t / 3600L;
        long mins = (t - hours * 3600L - secs) / 60L;
        String time = "";
        time = hours < 10L ? String.valueOf(time) + "0" + hours + ":" : String.valueOf(time) + hours + ":";
        time = mins < 10L ? String.valueOf(time) + "0" + mins + ":" : String.valueOf(time) + mins + ":";
        time = secs < 10L ? String.valueOf(time) + "0" + secs : String.valueOf(time) + secs;
        return time;
    }

    public void toggleTimer() {
        this.timerDisplayState = this.timerDisplayState == false;
        this.timeTakenTitle.setVisible(this.timerDisplayState);
        this.timeTaken.setVisible(this.timerDisplayState);
    }

    public void setTimer(Boolean on) {
        this.timerOn = on;
    }

    public void run() {
        System.out.println("Timer Initialised");
        long oldTime = 0L;
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.timerOn.booleanValue()) continue;
            this.puzzleTime = this.uiFrame.getPuzzleTime();
            ++this.puzzleTime;
            this.uiFrame.setPuzzleTime(this.puzzleTime);
            this.timeTaken.setText(this.timeToString(this.puzzleTime));
            if (this.puzzleTime - oldTime <= 9L) continue;
            oldTime = this.puzzleTime;
            System.out.println("Puzzle Time is " + this.timeToString(this.puzzleTime) + " (prints every 10 secs)");
        }
    }

    public void resetPanel() {
        System.out.println("Single Player Panel Reset");
        this.undoEnable(false);
        this.redoEnable(false);
        this.puzzleTime = 0L;
        this.timeTaken.setText(this.timeToString(this.puzzleTime));
        this.hintsUsed = this.uiFrame.getHintsUsed();
        this.hintsUsedSoFar.setText(String.valueOf(this.hintsUsed) + " Hints Used");
        this.hint.setEnabled(true);
        this.pause.setEnabled(true);
        this.save.setEnabled(true);
        this.reset.setEnabled(true);
        this.generateNew.setEnabled(true);
        this.endGame.setEnabled(true);
        if (this.uiFrame.getCustMode().booleanValue()) {
            this.generateNew.setText("New Custom Puzzle");
        } else {
            this.generateNew.setText("Generate New");
        }
    }

    public void solveDisplay() {
        this.setTimer(false);
        this.hint.setEnabled(false);
        this.undo.setEnabled(false);
        this.redo.setEnabled(false);
        this.pause.setEnabled(false);
        this.save.setEnabled(false);
        this.reset.setEnabled(false);
        this.generateNew.setEnabled(true);
        this.endGame.setEnabled(true);
    }

    public void updateHintDisplay() {
        this.hintsUsed = this.uiFrame.getHintsUsed();
        if (this.hintsUsed == 1) {
            this.hintsUsedSoFar.setText(String.valueOf(this.hintsUsed) + " Hint Used");
        } else {
            this.hintsUsedSoFar.setText(String.valueOf(this.hintsUsed) + " Hints Used");
        }
    }
}

