/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui.nav;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class StatusBar
extends JPanel {
    private Color c;
    private Dimension bar = new Dimension(0, 20);
    private Dimension box = new Dimension(160, 20);

    public StatusBar() {
        this.c = Color.blue;
        this.setBackground(Color.white);
        this.setBorder(new LineBorder(Color.BLACK));
        this.setMinimumSize(this.box);
        this.setMaximumSize(this.box);
        this.setPreferredSize(this.box);
    }

    public void barHasErrors(Boolean errors) {
        this.c = errors != false ? Color.red : Color.green;
        this.repaint();
    }

    public void setBarSize(int percentage) {
        int w = (int)this.box.getWidth();
        int h = (int)this.box.getHeight();
        w = w * percentage / 100;
        this.bar.setSize(w, h);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawBar(this.bar, g);
    }

    public void drawBar(Dimension d, Graphics g) {
        int h = (int)d.getHeight();
        int w = (int)d.getWidth();
        g.setColor(this.c);
        g.drawRect(0, 0, w, h);
        g.fillRect(0, 0, w, h);
    }
}

