/*
 * Decompiled with CFR 0.152.
 */
package sudoku.game;

import sudoku.game.Cell;
import sudoku.game.Puzzle;
import sudoku.game.PuzzleDifficulty;
import sudoku.game.UserSelectedType;

public class PuzzleHarness {
    public static void main(String[] args) {
        Puzzle p = new Puzzle(PuzzleDifficulty.NOT_RATED);
        System.out.println("Test case 1:");
        PuzzleHarness.display(p);
        System.out.println("Hints given: " + p.getHintsGiven());
        System.out.println("Time taken: " + p.getTime());
        System.out.println("");
        p.setGiven(0, 0, (byte)6);
        p.setGiven(1, 1, (byte)1);
        p.setGiven(2, 2, (byte)2);
        p.setGiven(80, (byte)9);
        p.setGiven(70, (byte)8);
        p.setDigit(79, (byte)8);
        p.setDigit(1, (byte)2);
        p.setDigit(3, 2, (byte)7);
        p.getCell(0, 4).setHintSelected(true);
        p.getCell(0, 5).setUserSelected(UserSelectedType.DIGIT);
        System.out.println("Test case 2:");
        PuzzleHarness.display(p);
        System.out.println("Percentage complete: " + p.getPercentageComplete());
        System.out.println("");
        p.clearUserSelected();
        System.out.println("Test case 3:");
        PuzzleHarness.display(p);
        System.out.println(" ");
        System.out.println("Test case 4:");
        p.clearHintSelected();
        PuzzleHarness.display(p);
        System.out.println(" ");
        System.out.println("Test case 5:");
        p.resetGrid();
        PuzzleHarness.display(p);
        System.out.println("Percentage complete: " + p.getPercentageComplete());
        System.out.println("");
        System.out.println("Test case 6:");
        Puzzle p2 = p.clone();
        PuzzleHarness.display(p);
        System.out.println("");
        PuzzleHarness.display(p2);
        System.out.println("");
        p.setGiven(0, 8, (byte)8);
        p.setTime(17L);
        System.out.println("Test case 7:");
        PuzzleHarness.display(p);
        System.out.println("Time taken: " + p.getTime());
        System.out.println("");
        PuzzleHarness.display(p2);
        System.out.println("Time taken: " + p2.getTime());
        System.out.println("");
        System.out.println("Test case 8:");
        p2.setGiven(8, 0, (byte)9);
        PuzzleHarness.display(p);
        System.out.println("");
        PuzzleHarness.display(p2);
    }

    public static void display(Puzzle p) {
        int j = 0;
        while (j <= 8) {
            String s = "";
            int i = 0;
            while (i <= 8) {
                Cell c = p.getCell(j, i);
                byte b = c.getValue();
                s = c.getUserSelected() == UserSelectedType.DIGIT || c.getHintSelected() ? String.valueOf(s) + "  " : String.valueOf(s) + b + " ";
                ++i;
            }
            System.out.println(s);
            ++j;
        }
    }
}

