/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import sudoku.game.Cell;
import sudoku.game.Puzzle;
import sudoku.game.UserSelectedType;
import sudoku.ui.DrawPuzzle;
import sudoku.ui.UIFrame;

public class MainPanel
extends JPanel
implements MouseListener,
KeyListener {
    private UIFrame uiFrame;
    private Puzzle puzzle = null;
    private Image logo = null;
    private Image scaledLogo = null;
    private Dimension logoSize = null;
    private Point scaledPos = new Point();
    private Dimension logoPanelSize = this.getSize();
    private Rectangle puzzlePos = null;
    private JScrollPane instructionsPane = null;
    private JButton hideButton = null;
    private boolean displayInstructions = false;
    private boolean editorMode = false;
    private Cell selectedCell = null;
    private boolean multipleSelected = false;
    private boolean gridReadOnly = false;

    public MainPanel(UIFrame uiFrame) {
        this.uiFrame = uiFrame;
        this.addMouseListener(this);
        this.addKeyListener(this);
        URL logoURL = this.getClass().getResource("LargeLogo.jpg");
        this.logo = this.getToolkit().getImage(logoURL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.logo, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException e) {
            System.out.println("Could not load LargoLogo.jpg");
        }
        this.logoSize = new Dimension(this.logo.getWidth(null), this.logo.getHeight(null));
        this.setBackground(Color.WHITE);
        this.setFocusable(true);
        JEditorPane instructionsEditor = new JEditorPane();
        URL instructionsHTML = this.getClass().getResource("Instructions.htm");
        try {
            instructionsEditor.setPage(instructionsHTML);
        }
        catch (IOException e) {
            System.out.println("Could not load Instructions.htm");
        }
        instructionsEditor.setEditable(false);
        instructionsEditor.setContentType("text/html");
        this.instructionsPane = new JScrollPane(instructionsEditor);
        this.instructionsPane.setVerticalScrollBarPolicy(22);
        this.instructionsPane.setVisible(false);
        this.hideButton = new JButton("Hide instructions");
        this.hideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.setDisplayInstructions(false);
            }
        });
        this.hideButton.setVisible(false);
        GridBagConstraints gbcButton = new GridBagConstraints();
        gbcButton.gridx = 0;
        gbcButton.insets = new Insets(0, 10, 10, 10);
        gbcButton.anchor = 13;
        gbcButton.gridy = 1;
        GridBagConstraints gbcText = new GridBagConstraints();
        gbcText.fill = 1;
        gbcText.gridy = 0;
        gbcText.ipady = 178;
        gbcText.weightx = 1.0;
        gbcText.weighty = 1.0;
        gbcText.insets = new Insets(10, 10, 10, 10);
        gbcText.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(300, 200);
        this.add((Component)this.instructionsPane, gbcText);
        this.add((Component)this.hideButton, gbcButton);
    }

    public void setPuzzle(Puzzle puzz) {
        this.puzzle = puzz;
        if (this.puzzle != null) {
            this.puzzle.clearUserSelected();
        }
        this.selectedCell = null;
        this.multipleSelected = false;
        this.repaint();
    }

    public void setDisplayInstructions(boolean show) {
        this.displayInstructions = show;
        if (show) {
            this.hideButton.setVisible(true);
            this.instructionsPane.setVisible(true);
        } else {
            this.hideButton.setVisible(false);
            this.instructionsPane.setVisible(false);
            this.uiFrame.hintPanelVisible(true);
        }
    }

    public void setEditorMode(boolean b) {
        this.editorMode = b;
    }

    public void setGridReadOnly(boolean b) {
        this.gridReadOnly = b;
        if (this.gridReadOnly) {
            this.puzzle.clearUserSelected();
            this.repaint();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (!this.displayInstructions) {
            if (this.puzzle == null) {
                if (!this.logoPanelSize.equals(this.getSize())) {
                    this.logoPanelSize = this.getSize();
                    float maxWidth = Math.min(this.logoPanelSize.width - 50, this.logoSize.width);
                    float maxHeight = Math.min(this.logoPanelSize.height - 50, this.logoSize.height);
                    float widthRatio = maxWidth / (float)this.logoSize.width;
                    float heightRatio = maxHeight / (float)this.logoSize.height;
                    float scFactor = Math.min(widthRatio, heightRatio);
                    float scaledWidth = (float)this.logoSize.width * scFactor;
                    float scaledHeight = (float)this.logoSize.height * scFactor;
                    Dimension scaledSize = new Dimension(Math.round(scaledWidth), Math.round(scaledHeight));
                    if (scaledSize.width != 0 && scaledSize.height != 0) {
                        this.scaledLogo = this.logo.getScaledInstance(scaledSize.width, scaledSize.height, 4);
                        MediaTracker mediaTracker = new MediaTracker(this);
                        mediaTracker.addImage(this.scaledLogo, 0);
                        try {
                            mediaTracker.waitForAll();
                        }
                        catch (InterruptedException e) {
                            System.out.println("There was a problem loading the logo.");
                        }
                        this.scaledPos.x = (this.logoPanelSize.width - scaledSize.width) / 2;
                        this.scaledPos.y = (this.logoPanelSize.height - scaledSize.height) / 2;
                    }
                }
                g.drawImage(this.scaledLogo, this.scaledPos.x, this.scaledPos.y, this);
            } else {
                int panelWidth = this.getWidth();
                int panelHeight = this.getHeight();
                int size = Math.min(panelWidth, panelHeight);
                this.puzzlePos = DrawPuzzle.draw(this.puzzle, g2, size - 50, panelWidth, panelHeight);
            }
        }
    }

    private Cell getCell(int x, int y) {
        if (this.puzzle != null) {
            int cellSize = this.puzzlePos.width / 9;
            int relativeX = x - this.puzzlePos.x;
            int relativeY = y - this.puzzlePos.y;
            if (relativeX > 0 && relativeX < this.puzzlePos.width && relativeY > 0 && relativeY < this.puzzlePos.height) {
                int cellX = relativeX / cellSize;
                int cellY = relativeY / cellSize;
                return this.puzzle.getCell(cellX, cellY);
            }
            return null;
        }
        return null;
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        Cell c = this.getCell(e.getX(), e.getY());
        if (c != null && !this.gridReadOnly) {
            boolean rightClk;
            byte val = c.getValue();
            int clicks = e.getClickCount();
            boolean bl = rightClk = e.getButton() == 3;
            if (clicks == 2 && !rightClk && val != 0) {
                this.selectAllCurrentVal();
            } else if (clicks == 1) {
                boolean goNormal;
                boolean goScribble = val == 0 && rightClk;
                boolean bl2 = goNormal = !rightClk;
                if (goScribble || goNormal) {
                    if (this.selectedCell != null) {
                        this.selectedCell.setUserSelected(UserSelectedType.NONE);
                    }
                    if (this.multipleSelected) {
                        this.puzzle.clearUserSelected();
                        this.multipleSelected = false;
                    }
                    if (goScribble) {
                        c.setUserSelected(UserSelectedType.SCRIBBLE);
                    } else {
                        c.setUserSelected(UserSelectedType.DIGIT);
                    }
                    this.selectedCell = c;
                    this.repaint();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.selectedCell != null) {
            boolean isEnterKey;
            int code = e.getKeyCode();
            char c = e.getKeyChar();
            int digit = c - 48;
            boolean digitMode = this.selectedCell.getUserSelected() == UserSelectedType.DIGIT;
            boolean scribbleMode = this.selectedCell.getUserSelected() == UserSelectedType.SCRIBBLE;
            boolean editAcceptable = !this.multipleSelected && (!this.selectedCell.getGiven() || this.selectedCell.getGiven() && this.editorMode);
            boolean isDigitKey = digit > 0 && digit < 10;
            boolean isDeleteKey = c == '\b' || c == '\u007f';
            boolean isArrowKey = code == 37 || code == 39 || code == 38 || code == 40;
            boolean isDorS = code == 68 || code == 83;
            boolean bl = isEnterKey = code == 10;
            if (editAcceptable) {
                Puzzle oldPuzz = this.puzzle.clone();
                if (isDigitKey && digitMode) {
                    if (this.selectedCell.getValue() != digit) {
                        this.selectedCell.setValue((byte)digit);
                        if (this.editorMode) {
                            this.selectedCell.setGiven(true);
                        }
                        this.uiFrame.changeMade(oldPuzz);
                        this.repaint();
                    }
                } else if (isDeleteKey && digitMode) {
                    if (this.selectedCell.getValue() != 0) {
                        this.selectedCell.setValue((byte)0);
                        if (this.editorMode) {
                            this.selectedCell.setGiven(false);
                        }
                        this.uiFrame.changeMade(oldPuzz);
                        this.repaint();
                    }
                } else if (isDeleteKey && scribbleMode) {
                    boolean changeMade = false;
                    int i = 0;
                    while (i < 9) {
                        if (this.selectedCell.getScribble(i)) {
                            this.selectedCell.setScribble(i, false);
                            changeMade = true;
                        }
                        ++i;
                    }
                    if (changeMade) {
                        this.uiFrame.changeMade(oldPuzz);
                        this.repaint();
                    }
                } else if (isDigitKey && scribbleMode) {
                    int scrArrayVal;
                    boolean currentScr = this.selectedCell.getScribble(scrArrayVal = digit - 1);
                    this.selectedCell.setScribble(scrArrayVal, !currentScr);
                    this.uiFrame.changeMade(oldPuzz);
                    this.repaint();
                }
            }
            if (isArrowKey) {
                this.arrowKeyPressed(code);
            } else if (isDorS && !this.selectedCell.getGiven() && this.selectedCell.getValue() == 0) {
                this.digitScribbleToggle(code);
            } else if (isEnterKey && this.selectedCell.getValue() != 0) {
                this.selectAllCurrentVal();
            }
        }
    }

    private void arrowKeyPressed(int code) {
        int xPos = this.selectedCell.getXPos();
        int yPos = this.selectedCell.getYPos();
        UserSelectedType ust = this.selectedCell.getUserSelected();
        Cell nextCell = null;
        do {
            switch (code) {
                case 37: {
                    xPos = xPos == 0 ? 8 : xPos - 1;
                    break;
                }
                case 39: {
                    xPos = xPos == 8 ? 0 : xPos + 1;
                    break;
                }
                case 38: {
                    yPos = yPos == 0 ? 8 : yPos - 1;
                    break;
                }
                case 40: {
                    yPos = yPos == 8 ? 0 : yPos + 1;
                }
            }
            nextCell = this.puzzle.getCell(xPos, yPos);
        } while (ust == UserSelectedType.SCRIBBLE && (nextCell.getGiven() || nextCell.getValue() != 0));
        if (this.multipleSelected) {
            this.puzzle.clearUserSelected();
            this.multipleSelected = false;
        } else {
            this.selectedCell.setUserSelected(UserSelectedType.NONE);
        }
        this.selectedCell = nextCell;
        this.selectedCell.setUserSelected(ust);
        this.repaint();
    }

    private void digitScribbleToggle(int code) {
        UserSelectedType ust = this.selectedCell.getUserSelected();
        if (ust == UserSelectedType.DIGIT && code == 83) {
            this.selectedCell.setUserSelected(UserSelectedType.SCRIBBLE);
            this.repaint();
        } else if (ust == UserSelectedType.SCRIBBLE && code == 68) {
            this.selectedCell.setUserSelected(UserSelectedType.DIGIT);
            this.repaint();
        }
    }

    private void selectAllCurrentVal() {
        if (this.selectedCell != null) {
            this.selectedCell.setUserSelected(UserSelectedType.NONE);
        }
        this.puzzle.selectAllVal(this.selectedCell.getValue());
        this.multipleSelected = true;
        this.repaint();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

