/*
 * Decompiled with CFR 0.152.
 */
package sudoku.game;

import java.io.Serializable;
import sudoku.game.Cell;
import sudoku.game.PuzzleDifficulty;
import sudoku.game.UserSelectedType;

public class Puzzle
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3L;
    private Cell[][] cells = new Cell[9][9];
    private PuzzleDifficulty difficulty;
    private long time = 0L;
    private int hintsGiven = 0;

    public Puzzle(PuzzleDifficulty d) {
        this.difficulty = d;
        int i = 0;
        while (i <= 8) {
            int j = 0;
            while (j <= 8) {
                this.cells[i][j] = new Cell((byte)i, (byte)j);
                ++j;
            }
            ++i;
        }
    }

    public void setDifficulty(PuzzleDifficulty d) {
        this.difficulty = d;
    }

    public PuzzleDifficulty getDifficulty() {
        return this.difficulty;
    }

    public void setTime(long t) {
        this.time = t;
    }

    public long getTime() {
        return this.time;
    }

    public void setHintsGiven(int h) {
        this.hintsGiven = h;
    }

    public int getHintsGiven() {
        return this.hintsGiven;
    }

    public Cell getCell(int x, int y) {
        return this.cells[x][y];
    }

    public Cell getCell(int x) {
        int row = x / 9;
        int column = x - row * 9;
        return this.getCell(row, column);
    }

    public void setGiven(int x, int y, byte v) {
        Cell c = this.getCell(x, y);
        c.setValue(v);
        c.setGiven(true);
    }

    public void setGiven(int x, byte v) {
        int row = x / 9;
        int column = x - row * 9;
        this.setGiven(row, column, v);
    }

    public void setDigit(int x, int y, byte v) {
        Cell c = this.getCell(x, y);
        c.setValue(v);
    }

    public void setDigit(int x, byte v) {
        int row = x / 9;
        int column = x - row * 9;
        this.setDigit(row, column, v);
    }

    public void selectAllVal(int n) {
        int i = 0;
        while (i <= 8) {
            int j = 0;
            while (j <= 8) {
                Cell c = this.cells[i][j];
                if (c.getValue() == n) {
                    c.setUserSelected(UserSelectedType.DIGIT);
                }
                ++j;
            }
            ++i;
        }
    }

    public void resetGrid() {
        int i = 0;
        while (i <= 8) {
            int j = 0;
            while (j <= 8) {
                Cell c = this.cells[i][j];
                if (!c.getGiven()) {
                    c.setValue((byte)0);
                    int k = 0;
                    while (k <= 8) {
                        c.setScribble(k, false);
                        ++k;
                    }
                    c.setUserSelected(UserSelectedType.NONE);
                }
                ++j;
            }
            ++i;
        }
    }

    public void clearUserSelected() {
        int i = 0;
        while (i <= 8) {
            int j = 0;
            while (j <= 8) {
                Cell c = this.cells[i][j];
                c.setUserSelected(UserSelectedType.NONE);
                ++j;
            }
            ++i;
        }
    }

    public void clearHintSelected() {
        int i = 0;
        while (i <= 8) {
            int j = 0;
            while (j <= 8) {
                Cell c = this.cells[i][j];
                c.setHintSelected(false);
                ++j;
            }
            ++i;
        }
    }

    public int getPercentageComplete() {
        int numberToComplete = 0;
        int numberCompleted = 0;
        int i = 0;
        while (i <= 8) {
            int j = 0;
            while (j <= 8) {
                Cell c = this.cells[i][j];
                if (!c.getGiven()) {
                    ++numberToComplete;
                    if (c.getValue() != 0) {
                        ++numberCompleted;
                    }
                }
                ++j;
            }
            ++i;
        }
        int percentage = numberCompleted * 100 / numberToComplete;
        return percentage;
    }

    public Puzzle clone() {
        try {
            Puzzle p = (Puzzle)super.clone();
            Cell[][] array = new Cell[9][9];
            int i = 0;
            while (i <= 8) {
                int j = 0;
                while (j <= 8) {
                    Cell cc = this.getCell(i, j);
                    array[i][j] = cc.clone();
                    ++j;
                }
                ++i;
            }
            p.cells = array;
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

