/*
 * Decompiled with CFR 0.152.
 */
package sudoku.game;

import sudoku.game.Hint;
import sudoku.game.Puzzle;
import sudoku.game.PuzzleDifficulty;
import sudoku.game.Solver;

public class Generator {
    Solver solver = new Solver();
    private int maxNumberOfGivens = 35;
    private static final Puzzle blankPuzzle = new Puzzle(null);
    private static Puzzle easyPuzzleHolder = new Puzzle(PuzzleDifficulty.EASY);
    private static Puzzle mildPuzzleHolder = new Puzzle(PuzzleDifficulty.MILD);
    private static Puzzle trickyPuzzleHolder = new Puzzle(PuzzleDifficulty.TRICKY);
    private static Puzzle difficultPuzzleHolder = new Puzzle(PuzzleDifficulty.DIFFICULT);
    private static Puzzle insanePuzzleHolder = new Puzzle(PuzzleDifficulty.INSANE);
    private static boolean existEasy = false;
    private static boolean existMild = false;
    private static boolean existTricky = false;
    private static boolean existDifficult = false;
    private static boolean existInsane = false;

    public static boolean checkValid(Puzzle p) {
        boolean isValid = false;
        Generator gener = new Generator();
        gener.solver.convertFromPuzzle(p);
        gener.solver.solve();
        boolean uniqueFlag = gener.solver.checkIfUnique();
        boolean solutionFlag = gener.solver.checkIfHasSolution();
        isValid = uniqueFlag & solutionFlag;
        return isValid;
    }

    public static Puzzle generate(PuzzleDifficulty pd) {
        System.out.println("generator called for " + pd);
        Generator gener = new Generator();
        Puzzle generatedFinal = new Puzzle(PuzzleDifficulty.NOT_RATED);
        if (pd == PuzzleDifficulty.EASY && existEasy) {
            generatedFinal = easyPuzzleHolder;
            easyPuzzleHolder = blankPuzzle;
            existEasy = false;
            Hint.rateDifficulty(generatedFinal);
            Generator.printPuzzle(generatedFinal);
            System.out.println("Easyout");
        } else if (pd == PuzzleDifficulty.MILD && existMild) {
            generatedFinal = mildPuzzleHolder;
            mildPuzzleHolder = blankPuzzle;
            existMild = false;
            Hint.rateDifficulty(generatedFinal);
            Generator.printPuzzle(generatedFinal);
            System.out.println("mildout");
        } else if (pd == PuzzleDifficulty.TRICKY && existTricky) {
            generatedFinal = trickyPuzzleHolder;
            trickyPuzzleHolder = blankPuzzle;
            existTricky = false;
            Hint.rateDifficulty(generatedFinal);
            Generator.printPuzzle(generatedFinal);
            System.out.println("trickyout");
        } else if (pd == PuzzleDifficulty.DIFFICULT && existDifficult) {
            generatedFinal = difficultPuzzleHolder;
            difficultPuzzleHolder = blankPuzzle;
            existDifficult = false;
            Hint.rateDifficulty(generatedFinal);
            Generator.printPuzzle(generatedFinal);
            System.out.println("difficultout");
        } else if (pd == PuzzleDifficulty.INSANE && existInsane) {
            generatedFinal = insanePuzzleHolder;
            insanePuzzleHolder = blankPuzzle;
            existInsane = false;
            Hint.rateDifficulty(generatedFinal);
            Generator.printPuzzle(generatedFinal);
            System.out.println("insaneout");
        } else {
            int numberOfGiven = 0;
            int tries = 1;
            while (tries < 201) {
                System.out.println("Try " + tries);
                if (tries == 200) {
                    if (pd == PuzzleDifficulty.MILD && existEasy) {
                        generatedFinal = easyPuzzleHolder;
                        easyPuzzleHolder = blankPuzzle;
                        existEasy = false;
                        Hint.rateDifficulty(generatedFinal);
                        Generator.printPuzzle(generatedFinal);
                        System.out.println("Timeout Easyout");
                        break;
                    }
                    if (pd == PuzzleDifficulty.TRICKY && existMild) {
                        generatedFinal = mildPuzzleHolder;
                        mildPuzzleHolder = blankPuzzle;
                        existMild = false;
                        Hint.rateDifficulty(generatedFinal);
                        Generator.printPuzzle(generatedFinal);
                        System.out.println("Timeout Mildout");
                        break;
                    }
                    if (pd == PuzzleDifficulty.DIFFICULT && existTricky) {
                        generatedFinal = trickyPuzzleHolder;
                        trickyPuzzleHolder = blankPuzzle;
                        existTricky = false;
                        Hint.rateDifficulty(generatedFinal);
                        Generator.printPuzzle(generatedFinal);
                        System.out.println("Timeout Trickyout");
                        break;
                    }
                    if (pd == PuzzleDifficulty.INSANE && existDifficult) {
                        generatedFinal = difficultPuzzleHolder;
                        difficultPuzzleHolder = blankPuzzle;
                        existDifficult = false;
                        Hint.rateDifficulty(generatedFinal);
                        Generator.printPuzzle(generatedFinal);
                        System.out.println("Timeout Difficultout");
                        break;
                    }
                    System.out.println("regenerate easy");
                    generatedFinal = Generator.generate(PuzzleDifficulty.EASY);
                }
                ++tries;
                gener.solver.produceRotationalSymmetric();
                Puzzle candadate = gener.solver.convertToPuzzle();
                Generator.printPuzzle(candadate);
                numberOfGiven = gener.solver.getNumberOfGivens();
                if (numberOfGiven <= gener.maxNumberOfGivens) {
                    PuzzleDifficulty difficulty = Hint.rateDifficulty(candadate);
                    if (difficulty == pd && numberOfGiven <= gener.maxNumberOfGivens) {
                        generatedFinal = candadate;
                        break;
                    }
                    if (difficulty == PuzzleDifficulty.EASY && !existEasy) {
                        easyPuzzleHolder = candadate;
                        existEasy = true;
                        System.out.println("EasyRecorded");
                        continue;
                    }
                    if (difficulty == PuzzleDifficulty.MILD && !existMild) {
                        mildPuzzleHolder = candadate;
                        existMild = true;
                        System.out.println("MildRecorded");
                        continue;
                    }
                    if (difficulty == PuzzleDifficulty.TRICKY && !existTricky) {
                        trickyPuzzleHolder = candadate;
                        existTricky = true;
                        System.out.println("TrickyRecorded");
                        continue;
                    }
                    if (difficulty == PuzzleDifficulty.DIFFICULT && !existDifficult) {
                        difficultPuzzleHolder = candadate;
                        existDifficult = true;
                        System.out.println("DifficultRecorded");
                        continue;
                    }
                    if (difficulty != PuzzleDifficulty.INSANE || existInsane) continue;
                    insanePuzzleHolder = candadate;
                    existInsane = true;
                    System.out.println("InsaneRecorded");
                    continue;
                }
                System.out.println("Too many givens . Discarded");
                System.out.println();
            }
            numberOfGiven = 0;
        }
        if (Generator.checkValid(generatedFinal)) {
            generatedFinal.setDifficulty(pd);
            System.out.println(pd + " Puzzle Generated");
        } else {
            System.out.println("Not Valid Puzzle , Restarted");
            generatedFinal = Generator.generate(pd);
        }
        return generatedFinal;
    }

    public static void printPuzzle(Puzzle p) {
        byte currentDigit = 0;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                if (p.getCell(j, i).getGiven()) {
                    currentDigit = p.getCell(j, i).getValue();
                    System.out.print(currentDigit);
                } else {
                    System.out.print(" ");
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static Puzzle solve(Puzzle p) {
        if (p == null) {
            Puzzle returnNull = null;
            return returnNull;
        }
        System.out.println("Solver Called");
        Generator gener = new Generator();
        gener.solver.convertFromPuzzle(p);
        gener.solver.solve();
        Puzzle converted = gener.solver.convertSolutionToPuzzle();
        return converted;
    }

    public static void print(Puzzle p) {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                boolean isGiven = p.getCell(i, j).getGiven();
                if (isGiven) {
                    byte currentDigit = p.getCell(i, j).getValue();
                    System.out.print(currentDigit);
                }
                System.out.print(" ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void toArraysOfCells(String input) {
        if (input.length() != 81) {
            return;
        }
        int[][] converted = new int[9][9];
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                char c = input.charAt(j * 9 + i);
                converted[i][j] = c >= '1' && c <= '9' ? c - 48 : 0;
                ++j;
            }
            ++i;
        }
        this.solver.toArraysOfCells(converted);
    }

    public int[][] toArrays(String input) {
        if (input.length() != 81) {
            int[][] blank = new int[9][9];
            return blank;
        }
        int[][] converted = new int[9][9];
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                char c = input.charAt(j * 9 + i);
                converted[i][j] = c >= '1' && c <= '9' ? c - 48 : 0;
                ++j;
            }
            ++i;
        }
        return converted;
    }

    void printArray(int[][] a) {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                System.out.print(a[i][j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    String toStrings(int[][] array) {
        String result = "";
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                result = array[i][j] == 0 ? result.concat(".") : result.concat(Integer.valueOf(array[i][j]).toString());
                ++j;
            }
            ++i;
        }
        return result;
    }

    static String toStrings(int[] array) {
        String result = "";
        int i = 1;
        while (i < 81) {
            result = array[i] == 0 ? result.concat(".") : result.concat(Integer.valueOf(array[i]).toString());
            ++i;
        }
        return result;
    }
}

