/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui.nav;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import sudoku.game.PuzzleDifficulty;
import sudoku.ui.UIFrame;
import sudoku.ui.nav.NavButtonTemplate;
import sudoku.ui.nav.NavTemplate;

public class NavDifficulty
extends NavTemplate {
    private UIFrame uiFrame;
    private NavButtonTemplate easy;
    private NavButtonTemplate mild;
    private NavButtonTemplate tricky;
    private NavButtonTemplate difficult;
    private NavButtonTemplate insane;
    private NavButtonTemplate custom;
    private NavButtonTemplate back;
    private Component vertSpace = Box.createVerticalStrut(5);
    private JLabel waitText = this.subTitleLabel("PLEASE WAIT!");
    private JTextPane waitInfo = this.textLabel("Your game is now being generated. Please note that this process may take a few seconds.");

    public NavDifficulty(UIFrame uiFrame, String title) {
        super(title);
        this.uiFrame = uiFrame;
        this.easy = new NavButtonTemplate("Easy");
        this.mild = new NavButtonTemplate("Mild");
        this.tricky = new NavButtonTemplate("Tricky");
        this.difficult = new NavButtonTemplate("Difficult");
        this.insane = new NavButtonTemplate("Insane");
        this.custom = new NavButtonTemplate("Custom");
        this.back = new NavButtonTemplate("Back");
        this.add(this.easy);
        this.add(this.vSpace());
        this.add(this.mild);
        this.add(this.vSpace());
        this.add(this.tricky);
        this.add(this.vSpace());
        this.add(this.difficult);
        this.add(this.vSpace());
        this.add(this.insane);
        this.add(this.vSpace());
        this.add(this.custom);
        this.add(this.vertSpace);
        this.add(this.back);
        this.add(this.vSpace(20));
        this.add(this.waitText);
        this.add(this.vSpace());
        this.add(this.waitInfo);
        this.waitText.setVisible(false);
        this.waitInfo.setVisible(false);
        this.easy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Easy");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.EASY);
            }
        });
        this.mild.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Mild");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.MILD);
            }
        });
        this.tricky.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Tricky");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.TRICKY);
            }
        });
        this.difficult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Difficult");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.DIFFICULT);
            }
        });
        this.insane.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Insane");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.INSANE);
            }
        });
        this.custom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Custom");
                NavDifficulty.this.customPuzzle();
            }
        });
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Back");
                NavDifficulty.this.backButton();
            }
        });
    }

    public void buttonDifficulty(PuzzleDifficulty d) {
        this.waitingState(true);
        if (this.uiFrame.getCompMode().booleanValue()) {
            this.uiFrame.generatePuzzle(d);
        }
        if (this.uiFrame.getSingMode().booleanValue()) {
            this.uiFrame.generatePuzzle(d);
        }
    }

    public void customPuzzle() {
        this.uiFrame.editCustomPuzzle();
    }

    public void backButton() {
        if (this.uiFrame.getCompMode().booleanValue()) {
            this.uiFrame.showNavComp();
        }
        if (this.uiFrame.getSingMode().booleanValue()) {
            this.uiFrame.showNavMain();
        }
    }

    public void waitingState(Boolean on) {
        this.waitText.setVisible(on);
        this.waitInfo.setVisible(on);
        this.easy.setEnabled(on == false);
        this.mild.setEnabled(on == false);
        this.tricky.setEnabled(on == false);
        this.difficult.setEnabled(on == false);
        this.insane.setEnabled(on == false);
        this.custom.setEnabled(on == false);
        this.back.setEnabled(on == false);
    }

    public void setCustomOption(Boolean on) {
        this.custom.setVisible(on);
        this.vertSpace.setVisible(on);
        this.custom.setEnabled(on);
    }
}

