/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import sudoku.game.Puzzle;
import sudoku.ui.SingleEndResult;

public class SingleEndDialog
extends JDialog {
    private JDialog dlg;
    private Container spWon;
    private Container spErrors;
    private SingleEndResult result;
    private Puzzle puzzle;

    public SingleEndDialog(Frame owner, Puzzle puzzle) {
        this.puzzle = puzzle;
        this.dlg = new JDialog(owner, true);
        this.dlg.setTitle("Game Finished");
        this.dlg.setBackground(Color.WHITE);
        this.dlg.setResizable(false);
        this.dlg.setModal(true);
        this.spWon = new Container();
        ImageIcon imageWon = new ImageIcon(this.getClass().getResource("spWon.jpg"));
        JLabel imageLabelWon = new JLabel(imageWon);
        imageLabelWon.setBounds(0, 0, imageWon.getIconWidth(), imageWon.getIconHeight());
        long time = puzzle.getTime();
        long hours = time / 3600L;
        long minutes = (time - hours * 3600L) / 60L;
        long seconds = time - hours * 3600L - minutes * 60L;
        int numOfHints = puzzle.getHintsGiven();
        String h = hours == 0L ? "" : (hours == 1L ? String.valueOf(hours) + " hour, " : String.valueOf(hours) + " hours, ");
        String m = minutes == 1L ? String.valueOf(minutes) + " minute and " : String.valueOf(minutes) + " minutes and ";
        String s = seconds == 1L ? String.valueOf(seconds) + " second." : String.valueOf(seconds) + " seconds.";
        JLabel textLabel1 = new JLabel("You have successfully completed the puzzle.");
        JLabel textLabel2 = hours == 0L ? new JLabel("Time taken : " + m + s) : new JLabel("Time taken : " + h + m + s);
        JLabel textLabel3 = new JLabel("Number of Hints used : " + numOfHints + ".");
        JButton newPuzzleButtonWon = new JButton();
        newPuzzleButtonWon.setHorizontalAlignment(0);
        newPuzzleButtonWon.setText("  New Puzzle  ");
        newPuzzleButtonWon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SingleEndDialog.this.result = SingleEndResult.NEW_PUZZLE;
                System.out.println("New Puzzle");
                SingleEndDialog.this.dlg.setVisible(false);
            }
        });
        JButton returnToGridButtonWon = new JButton();
        returnToGridButtonWon.setHorizontalAlignment(0);
        returnToGridButtonWon.setText(" Return to Grid ");
        returnToGridButtonWon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SingleEndDialog.this.result = SingleEndResult.RETURN_TO_GRID;
                System.out.println("Return to grid");
                SingleEndDialog.this.dlg.setVisible(false);
            }
        });
        JButton endGameButtonWon = new JButton();
        endGameButtonWon.setHorizontalAlignment(0);
        endGameButtonWon.setText(" End Game ");
        endGameButtonWon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SingleEndDialog.this.result = SingleEndResult.END_GAME;
                System.out.println("End Game");
                SingleEndDialog.this.dlg.setVisible(false);
            }
        });
        Container spCongrats = new Container();
        spCongrats.setLayout(new BoxLayout(spCongrats, 1));
        imageLabelWon.setAlignmentX(0.5f);
        textLabel1.setAlignmentX(0.5f);
        textLabel2.setAlignmentX(0.5f);
        textLabel3.setAlignmentX(0.5f);
        spCongrats.add(imageLabelWon);
        spCongrats.add(textLabel1);
        spCongrats.add(textLabel2);
        spCongrats.add(textLabel3);
        this.spWon.setLayout(new BorderLayout());
        this.spWon.add((Component)spCongrats, "North");
        Container spWonButtons = new Container();
        spWonButtons.setLayout(new BoxLayout(spWonButtons, 0));
        spWonButtons.add(Box.createRigidArea(new Dimension(23, 80)));
        spWonButtons.add(newPuzzleButtonWon);
        spWonButtons.add(Box.createRigidArea(new Dimension(10, 80)));
        spWonButtons.add(returnToGridButtonWon);
        spWonButtons.add(Box.createRigidArea(new Dimension(10, 80)));
        spWonButtons.add(endGameButtonWon);
        this.spWon.add((Component)spWonButtons, "South");
        this.spErrors = new Container();
        ImageIcon imageErrors = new ImageIcon(this.getClass().getResource("spErrors.jpg"));
        JLabel imageLabelErrors = new JLabel(imageErrors);
        imageLabelErrors.setBounds(0, 0, imageErrors.getIconWidth(), imageErrors.getIconHeight());
        JButton OKButtonErrors = new JButton();
        OKButtonErrors.setHorizontalAlignment(0);
        OKButtonErrors.setText(" OK ");
        OKButtonErrors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SingleEndDialog.this.result = SingleEndResult.ERRORS_OK;
                System.out.println("Errors OK");
                SingleEndDialog.this.dlg.setVisible(false);
            }
        });
        Container spErrorsButtons = new Container();
        spErrorsButtons.setLayout(new BoxLayout(spErrorsButtons, 0));
        spErrorsButtons.add(Box.createRigidArea(new Dimension(168, 55)));
        spErrorsButtons.add(OKButtonErrors);
        this.spErrors.setLayout(new BorderLayout());
        this.spErrors.add((Component)imageLabelErrors, "North");
        this.spErrors.add((Component)spErrorsButtons, "South");
    }

    public SingleEndResult showWon() {
        this.dlg.setSize(400, 220);
        Container parent = this.dlg.getParent();
        Dimension parentSize = parent.getSize();
        Dimension window = this.dlg.getSize();
        Point parentPos = parent.getLocation();
        Point dlgPos = new Point();
        dlgPos.x = parentSize.width > window.width ? parentPos.x + (parentSize.width - window.width) / 2 : parentPos.x;
        dlgPos.y = parentSize.height > window.height ? parentPos.y + (parentSize.height - window.height) / 2 : parentPos.y;
        this.dlg.setLocation(dlgPos);
        this.dlg.setContentPane(this.spWon);
        this.dlg.setVisible(true);
        return this.result;
    }

    public SingleEndResult showErrors() {
        this.dlg.setSize(400, 200);
        Container parent = this.dlg.getParent();
        Dimension parentSize = parent.getSize();
        Dimension window = this.dlg.getSize();
        Point parentPos = parent.getLocation();
        Point dlgPos = new Point();
        dlgPos.x = parentSize.width > window.width ? parentPos.x + (parentSize.width - window.width) / 2 : parentPos.x;
        dlgPos.y = parentSize.height > window.height ? parentPos.y + (parentSize.height - window.height) / 2 : parentPos.y;
        this.dlg.setLocation(dlgPos);
        this.dlg.setContentPane(this.spErrors);
        this.dlg.setVisible(true);
        return this.result;
    }
}

