/*
 * Decompiled with CFR 0.152.
 */
package sudoku.network;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import sudoku.game.Puzzle;
import sudoku.network.NetworkInterface;
import sudoku.ui.UIFrame;

public class Server
implements NetworkInterface {
    private UIFrame uiFrame;
    private DatagramSocket d;
    private ServerSocket s;
    private boolean c = true;
    private boolean w = false;
    private boolean offf = false;
    private boolean x = true;
    private byte[] localstatus = new byte[2];
    private byte[] goodbye = new byte[1];
    private udpConnection u;
    private tcpConnection t;

    public Server(UIFrame uiFrame) {
        this.uiFrame = uiFrame;
    }

    public void startHosting(Puzzle p) {
        this.c = true;
        try {
            InetSocketAddress inetserver = new InetSocketAddress(InetAddress.getLocalHost(), 10003);
            this.d = new DatagramSocket(10001);
            System.out.println(this.d.getLocalSocketAddress());
            System.out.println(this.d.isBound());
            this.s = new ServerSocket();
            this.s.bind(inetserver, 1);
            try {
                this.d.setSoTimeout(0);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            this.u = new udpConnection(p, this.d);
            new Thread(this.u).start();
            this.t = new tcpConnection(p);
            new Thread(this.t).start();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void cancelHosting() {
        try {
            this.c = false;
            if (this.t.server.isConnected()) {
                this.goodbye[0] = -2;
                this.t.out.write(this.goodbye);
            }
            this.t.in.close();
            this.d.close();
            this.s.close();
        }
        catch (NullPointerException e) {
            this.d.close();
            try {
                this.s.close();
            }
            catch (IOException p) {
                return;
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reportLocalStatus(int cellsComplete, boolean errors) {
        this.localstatus[0] = (byte)cellsComplete;
        this.localstatus[1] = errors ? 1 : 2;
        this.w = true;
        try {
            this.t.out.write(this.localstatus);
        }
        catch (IOException e) {
            return;
        }
    }

    class udpConnection
    extends Thread {
        DatagramSocket client;
        Puzzle p;
        int i = 0;
        ByteArrayOutputStream bytearray = new ByteArrayOutputStream();
        byte[] buffer = new byte[100];
        DatagramPacket pack = new DatagramPacket(new byte[100], 100);

        public udpConnection(Puzzle p, DatagramSocket client) throws SocketException {
            this.client = client;
            this.p = p;
        }

        public void run() {
            try {
                ObjectOutputStream oout = new ObjectOutputStream(this.bytearray);
                while (Server.this.c) {
                    try {
                        this.client.receive(this.pack);
                        System.out.println("receive from client");
                    }
                    catch (SocketTimeoutException e) {
                        e.printStackTrace();
                    }
                    this.buffer = this.pack.getData();
                    System.out.println(this.buffer[0]);
                    if (this.buffer[0] != 0) continue;
                    oout.writeObject(this.p.getDifficulty());
                    oout.flush();
                    byte[] outputbytes = this.bytearray.toByteArray();
                    DatagramPacket newpacket = new DatagramPacket(outputbytes, outputbytes.length, this.pack.getSocketAddress());
                    this.client.send(newpacket);
                    System.out.println("send out!");
                }
                this.bytearray.close();
                oout.close();
                this.client.close();
                return;
            }
            catch (SocketException e) {
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class tcpConnection
    extends Thread {
        boolean goodbyeflag = false;
        Socket server;
        Puzzle z;
        OutputStream out;
        InputStream in;
        boolean off = false;
        byte[] buffer = new byte[2];

        public void killThread() {
            try {
                this.server.close();
                Server.this.s.close();
                Server.this.d.close();
            }
            catch (SocketException e) {
                return;
            }
            catch (IOException e) {
                return;
            }
        }

        public tcpConnection(Puzzle z) throws SocketException {
            this.z = z;
        }

        public void run() {
            try {
                try {
                    this.server = Server.this.s.accept();
                    Server.this.s.close();
                    Server.this.d.close();
                    this.server.setSoLinger(this.off, 0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    this.out = this.server.getOutputStream();
                    this.in = this.server.getInputStream();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ObjectOutputStream oout = new ObjectOutputStream(this.out);
                oout.writeObject(this.z);
                oout.flush();
                this.in.read(this.buffer);
                if (this.buffer[0] == -1) {
                    Server.this.uiFrame.beginCompetition();
                    this.buffer[0] = 0;
                    while (Server.this.c) {
                        this.in.read(this.buffer);
                        if (this.buffer[0] == -2) {
                            this.killThread();
                            Server.this.uiFrame.connectionLost();
                            this.buffer[0] = 0;
                            return;
                        }
                        if (this.buffer[1] == 1) {
                            Server.this.uiFrame.setOpponentProgress(this.buffer[0], true);
                            this.buffer[1] = 0;
                        } else if (this.buffer[1] == 2) {
                            Server.this.uiFrame.setOpponentProgress(this.buffer[0], false);
                            this.buffer[1] = 0;
                        }
                        if (!Server.this.w) continue;
                        this.out.write(Server.this.localstatus);
                        Server.this.w = false;
                    }
                }
                this.in.close();
                this.out.close();
                this.server.close();
                return;
            }
            catch (NullPointerException e) {
                return;
            }
            catch (SocketException e) {
                return;
            }
            catch (IOException e) {
                System.out.println("I/O error" + e);
                Server.this.uiFrame.connectionLost();
                return;
            }
        }
    }
}

