/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextPane;

public class NavTemplate
extends Box {
    private String menuName;
    private Image background = null;
    private Image scaledBackground = null;
    private Point scaledPos = new Point();
    private Dimension logoPanelSize = this.getSize();
    private Dimension logoSize;
    private Dimension scaledSize;

    public NavTemplate(String menuTitle) {
        super(1);
        URL logoURL = this.getClass().getResource("SideLogo.jpg");
        this.background = this.getToolkit().getImage(logoURL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.background, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException e) {
            System.out.println("Could not load SideLogo.jpg");
        }
        this.logoSize = new Dimension(this.background.getWidth(null), this.background.getHeight(null));
        this.menuName = menuTitle;
        this.add(this.vSpace(15));
        this.drawTitle();
        this.add(this.vSpace(15));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(Color.white);
        int offset = 420;
        int margin = 20;
        if (!this.logoPanelSize.equals(this.getSize())) {
            this.logoPanelSize = this.getSize();
            float maxHeight = Math.min(this.logoPanelSize.height - offset - 2 * margin, this.logoSize.height - 2 * margin);
            float scFactor = maxHeight / (float)this.logoSize.height;
            float scaledWidth = (float)this.logoSize.width * scFactor;
            float scaledHeight = (float)this.logoSize.height * scFactor;
            this.scaledSize = new Dimension(Math.round(scaledWidth), Math.round(scaledHeight));
            if (this.scaledSize.width != 0 && this.scaledSize.height != 0) {
                this.scaledBackground = this.background.getScaledInstance(this.scaledSize.width, this.scaledSize.height, 4);
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.scaledBackground, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException e) {
                    System.out.println("There was a problem loading the logo.");
                }
                this.scaledPos.x = (this.logoPanelSize.width - this.scaledSize.width) / 2;
                this.scaledPos.y = offset + margin;
            }
        }
        if (this.scaledSize.height > 200) {
            g.drawImage(this.scaledBackground, this.scaledPos.x, this.scaledPos.y, this);
        }
    }

    public void drawTitle() {
        JLabel title = new JLabel();
        title.setText(this.menuName);
        title.setForeground(new Color(25, 9, 145));
        title.setFont(new Font("SansSerif", 1, 16));
        title.setAlignmentX(0.5f);
        title.setAlignmentY(0.0f);
        this.add(title);
    }

    public JLabel subTitleLabel(String subTitleName) {
        JLabel subTitle = new JLabel();
        subTitle.setText(subTitleName);
        subTitle.setForeground(Color.black);
        subTitle.setFont(new Font("SansSerif", 1, 14));
        subTitle.setAlignmentX(0.5f);
        subTitle.setAlignmentY(0.0f);
        return subTitle;
    }

    public JTextPane textLabel(String text) {
        JTextPane textBlock = new JTextPane();
        textBlock.setText(text);
        textBlock.setEditable(false);
        Font f = new Font("SansSerif", 0, 12);
        textBlock.setFont(f);
        textBlock.setOpaque(false);
        textBlock.setAlignmentY(0.0f);
        return textBlock;
    }

    public Component vSpace() {
        Component vertSpace = Box.createVerticalStrut(5);
        return vertSpace;
    }

    public Component vSpace(int s) {
        Component vertSpace = Box.createVerticalStrut(s);
        return vertSpace;
    }
}

