/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import sudoku.ui.UIFrame;
import sudoku.ui.nav.NavButtonTemplate;
import sudoku.ui.nav.NavTemplate;
import sudoku.ui.nav.StatusBar;

public class NavCompPlay
extends NavTemplate {
    private UIFrame uiFrame;
    private int hintsRemaining;
    private NavButtonTemplate hint;
    private NavButtonTemplate undo;
    private NavButtonTemplate redo;
    private NavButtonTemplate reset;
    private NavButtonTemplate endGame;
    private StatusBar localStatus;
    private StatusBar opponentStatus;

    public NavCompPlay(UIFrame uiFrame, String title) {
        super(title);
        this.uiFrame = uiFrame;
        this.hint = new NavButtonTemplate("Hint!");
        this.undo = new NavButtonTemplate("Undo");
        this.redo = new NavButtonTemplate("Redo");
        this.reset = new NavButtonTemplate("Reset Grid");
        this.endGame = new NavButtonTemplate("End Game");
        this.localStatus = new StatusBar();
        this.opponentStatus = new StatusBar();
        this.opponentStatus.barHasErrors(false);
        Box b = new Box(0);
        Dimension d = new Dimension(77, 35);
        this.undo.setMinimumSize(d);
        this.redo.setMinimumSize(d);
        this.undo.setMaximumSize(d);
        this.redo.setMaximumSize(d);
        JPanel statusPanel = new JPanel();
        statusPanel.setOpaque(false);
        this.add(this.hint);
        this.add(this.vSpace());
        b.add(this.undo);
        b.add(Box.createHorizontalStrut(6));
        b.add(this.redo);
        b.setMinimumSize(new Dimension(160, 35));
        b.setMaximumSize(new Dimension(160, 35));
        this.add(b);
        this.add(this.vSpace());
        this.add(this.reset);
        this.add(this.vSpace());
        this.add(this.endGame);
        GridBagConstraints gBC = new GridBagConstraints();
        gBC.insets = new Insets(10, 0, 0, 0);
        gBC.gridx = 1;
        gBC.gridy = 0;
        gBC.gridwidth = 3;
        gBC.anchor = 10;
        gBC.weightx = 0.0;
        gBC.weighty = 0.0;
        gBC.fill = 10;
        GridBagConstraints gBC1 = new GridBagConstraints();
        gBC1.insets = new Insets(10, 20, 0, 20);
        gBC1.gridx = 1;
        gBC1.gridy = 1;
        gBC1.gridwidth = 3;
        gBC1.anchor = 17;
        gBC1.fill = 2;
        gBC1.weightx = 0.0;
        gBC1.weighty = 0.0;
        GridBagConstraints gBC2 = new GridBagConstraints();
        gBC2.insets = new Insets(0, 20, 0, 0);
        gBC2.gridx = 1;
        gBC2.gridy = 2;
        gBC2.gridwidth = 1;
        gBC2.anchor = 10;
        gBC2.fill = 10;
        gBC2.weightx = 0.0;
        gBC2.weighty = 0.0;
        GridBagConstraints gBC3 = new GridBagConstraints();
        gBC3.insets = new Insets(10, 20, 0, 20);
        gBC3.gridx = 1;
        gBC3.gridy = 3;
        gBC3.gridwidth = 3;
        gBC3.anchor = 17;
        gBC3.fill = 2;
        gBC3.weightx = 0.0;
        gBC3.weighty = 0.0;
        GridBagConstraints gBC4 = new GridBagConstraints();
        gBC4.insets = new Insets(0, 20, 0, 0);
        gBC4.gridx = 1;
        gBC4.gridy = 4;
        gBC4.gridwidth = 1;
        gBC4.anchor = 10;
        gBC4.fill = 10;
        gBC4.weightx = 0.0;
        gBC4.weighty = 0.0;
        GridBagConstraints gBC5 = new GridBagConstraints();
        gBC5.insets = new Insets(10, 20, 0, 20);
        gBC5.gridx = 0;
        gBC5.gridy = 5;
        gBC5.gridwidth = 3;
        gBC5.anchor = 11;
        gBC5.fill = 2;
        gBC5.weightx = 1.0;
        gBC5.weighty = 1.0;
        JTextPane note = this.textLabel("Note: The status bars are based on the number of cells entered, not the number of correct cells. Your status bar will always remain blue but if your opponent's status bar turns red it means they have made errors!");
        note.setOpaque(false);
        statusPanel.setBackground(Color.white);
        statusPanel.setLayout(new GridBagLayout());
        statusPanel.add((Component)this.subTitleLabel("Game Status"), gBC);
        statusPanel.add((Component)this.textLabel("Your Status"), gBC1);
        statusPanel.add((Component)this.localStatus, gBC2);
        statusPanel.add((Component)this.textLabel("Your Opponent's Status"), gBC3);
        statusPanel.add((Component)this.opponentStatus, gBC4);
        statusPanel.add((Component)note, gBC5);
        this.add(statusPanel);
        this.hint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Hint");
                NavCompPlay.this.hintButton();
            }
        });
        this.undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Undo");
                NavCompPlay.this.undoButton();
            }
        });
        this.redo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Redo");
                NavCompPlay.this.redoButton();
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Reset");
                NavCompPlay.this.resetButton();
            }
        });
        this.endGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - End Game");
                NavCompPlay.this.endGameButton();
            }
        });
        this.resetPanel();
    }

    public void resetPanel() {
        this.hintsRemaining = 10;
        this.undoEnable(false);
        this.redoEnable(false);
        this.hint.setText("Hint! (" + this.hintsRemaining + " remaining)");
        this.hint.setEnabled(true);
    }

    public void setOpponentProgress(int percentage, boolean errors) {
        this.opponentStatus.setBarSize(percentage);
        this.showOpponentError(errors);
        System.out.println("NavCompPlay Received Opponent Progress: " + percentage + "% Errors: " + errors);
        if (percentage == 100 && !errors) {
            this.uiFrame.localPlayerLost();
        }
    }

    public void setPlayerProgress(int percentage) {
        this.localStatus.setBarSize(percentage);
    }

    public void hintButton() {
        this.uiFrame.hint();
    }

    public void undoButton() {
        this.uiFrame.undo();
    }

    public void redoButton() {
        this.uiFrame.redo();
    }

    public void endGameButton() {
        this.uiFrame.endGame();
    }

    public void resetButton() {
        this.uiFrame.resetGrid();
        this.setPlayerProgress(0);
    }

    public void updateHintDisplay(int hintsAllowed) {
        this.hintsRemaining = hintsAllowed - this.uiFrame.getHintsUsed();
        this.hint.setText("Hint! (" + this.hintsRemaining + " remaining)");
    }

    public void disableHintButton() {
        this.hint.setEnabled(false);
        this.hint.setText("All Hints Used!");
    }

    public void undoEnable(Boolean on) {
        this.undo.setEnabled(on);
    }

    public void redoEnable(Boolean on) {
        this.redo.setEnabled(on);
    }

    public void showOpponentError(Boolean error) {
        this.opponentStatus.barHasErrors(error);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }
}

