/*
 * Decompiled with CFR 0.152.
 */
package sudoku.ui.nav;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import sudoku.game.PuzzleDifficulty;
import sudoku.ui.UIFrame;
import sudoku.ui.nav.NavButtonTemplate;
import sudoku.ui.nav.NavTemplate;

public class NavDifficulty
extends NavTemplate {
    private UIFrame uiFrame;
    private NavButtonTemplate easy;
    private NavButtonTemplate mild;
    private NavButtonTemplate tricky;
    private NavButtonTemplate difficult;
    private NavButtonTemplate insane;
    private NavButtonTemplate custom;
    private NavButtonTemplate back;
    private Component vertSpace = Box.createVerticalStrut(5);
    private JLabel waitText = this.subTitleLabel("PLEASE WAIT!");
    private JTextPane waitInfo = this.textLabel("Your game is now being generated. Please note that this process may take a few seconds.");

    public NavDifficulty(UIFrame uiFrame, String title) {
        super(title);
        this.uiFrame = uiFrame;
        this.easy = new NavButtonTemplate("Easy");
        this.mild = new NavButtonTemplate("Mild");
        this.tricky = new NavButtonTemplate("Tricky");
        this.difficult = new NavButtonTemplate("Difficult");
        this.insane = new NavButtonTemplate("Insane");
        this.custom = new NavButtonTemplate("Custom");
        this.back = new NavButtonTemplate("Back");
        this.add(this.easy);
        this.add(this.vSpace());
        this.add(this.mild);
        this.add(this.vSpace());
        this.add(this.tricky);
        this.add(this.vSpace());
        this.add(this.difficult);
        this.add(this.vSpace());
        this.add(this.insane);
        this.add(this.vSpace());
        this.add(this.custom);
        this.add(this.vertSpace);
        this.add(this.back);
        this.add(this.vSpace(20));
        this.add(this.waitText);
        this.add(this.vSpace());
        JPanel waitTextPanel = new JPanel();
        waitTextPanel.setLayout(new GridBagLayout());
        GridBagConstraints gBC = new GridBagConstraints();
        gBC.insets = new Insets(0, 20, 0, 20);
        gBC.gridx = 0;
        gBC.gridy = 0;
        gBC.gridwidth = 1;
        gBC.anchor = 11;
        gBC.fill = 2;
        gBC.weightx = 1.0;
        gBC.weighty = 0.0;
        GridBagConstraints gBC2 = new GridBagConstraints();
        gBC2.insets = new Insets(0, 20, 0, 20);
        gBC2.gridx = 0;
        gBC2.gridy = 0;
        gBC2.gridwidth = 1;
        gBC2.anchor = 11;
        gBC2.fill = 2;
        gBC2.weightx = 1.0;
        gBC2.weighty = 1.0;
        waitTextPanel.setOpaque(false);
        waitTextPanel.add((Component)this.waitInfo, gBC);
        waitTextPanel.add(this.vSpace(), gBC2);
        this.add(waitTextPanel);
        this.waitText.setVisible(false);
        this.waitInfo.setVisible(false);
        this.waitText.setOpaque(false);
        this.waitInfo.setOpaque(false);
        this.easy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Easy");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.EASY);
            }
        });
        this.mild.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Mild");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.MILD);
            }
        });
        this.tricky.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Tricky");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.TRICKY);
            }
        });
        this.difficult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Difficult");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.DIFFICULT);
            }
        });
        this.insane.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Insane");
                NavDifficulty.this.buttonDifficulty(PuzzleDifficulty.INSANE);
            }
        });
        this.custom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Custom");
                NavDifficulty.this.customPuzzle();
            }
        });
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Nav Button Pushed - Back");
                NavDifficulty.this.backButton();
            }
        });
    }

    public void buttonDifficulty(PuzzleDifficulty d) {
        this.waitingState(true);
        if (this.uiFrame.getCompMode().booleanValue()) {
            this.uiFrame.generatePuzzle(d);
        }
        if (this.uiFrame.getSingMode().booleanValue()) {
            this.uiFrame.generatePuzzle(d);
        }
    }

    public void customPuzzle() {
        this.uiFrame.editCustomPuzzle();
    }

    public void backButton() {
        if (this.uiFrame.getCompMode().booleanValue()) {
            this.uiFrame.showNavComp();
        }
        if (this.uiFrame.getSingMode().booleanValue()) {
            this.uiFrame.showNavMain();
        }
    }

    public void waitingState(Boolean on) {
        this.waitText.setVisible(on);
        this.waitInfo.setVisible(on);
        this.easy.setEnabled(on == false);
        this.mild.setEnabled(on == false);
        this.tricky.setEnabled(on == false);
        this.difficult.setEnabled(on == false);
        this.insane.setEnabled(on == false);
        this.custom.setEnabled(on == false);
        this.back.setEnabled(on == false);
        if (on.booleanValue()) {
            this.waitText.requestFocusInWindow();
        }
    }

    public void setCustomOption(Boolean on) {
        this.custom.setVisible(on);
        this.vertSpace.setVisible(on);
        this.custom.setEnabled(on);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }
}

